#if !defined(CANVAS3D_H)
#define CANVAS3D_H

/****************************************************************************/
/** \class Canvas3D
    \brief Schnittstelle zur Render-Engine. 
           Beinhaltet OS-spezifische Unterscheidungen
*****************************************************************************/
class Canvas3D
{
private:
   Engine* m_engine;

   int m_widthCanvas;
   int m_heightCanvas;

   int m_height;
   int m_width;

   int m_startX;
   int m_startY;

   BYTE *m_pDib; 

#ifdef WIN32
   HDC  m_hdc;
#endif

public:
   BYTE *m_pDiData; 

   static Canvas3D* getInstance();

protected:
	Canvas3D();

private:

#ifdef WIN32
   void paintBltBit(HDC hdc);
   void paintCanvas(HDC hdc);
#endif

   bool createImage();
   void InitBitmap (BYTE *pDiData, int cxWinSize, int cyWinSize);
   void flipImage(void);

   static Canvas3D* _instance;

public:
   
#ifdef WIN32    
   void paint (HDC hdc);
#else
   void paint(void);
#endif

   bool   init(char* fname);
   void   initialize(int widthCanvas, int heightCanvas, int width, int height);
   void   renderFrame (void);
   bool   inputKey(bool pressed, int key);
   double getFrameRate(void);
   int    getTilesPerFrame(void);
   int    getPartikelsPerFrame(void);

	virtual ~Canvas3D();
};
#endif // !defined(CANVAS3D_H)
