#include "stdafx.h"

#include <vector>
#include <math.h>

#include "DataOutputStream.h"
#include "DataInputStream.h"

#include "TArc.h"
#include "Vec.h"
#include "Matrix.h"

#include "Camera.h"
#include "Tile.h"
#include "Map.h"

#include "LightManager.h"
#include "SkyBox.h"

#include "AnimationManager.h"

#include "EngineIO.h"

// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

EngineIO* EngineIO::_instance = 0;

/****************************************************************************/
/** \brief Liefert die Singleton-Instanz
    \return Pointer auf die Instanz
*****************************************************************************/
EngineIO* EngineIO::getInstance()
{
 if (_instance == 0) 
   _instance = new EngineIO();
 return _instance;
}

/****************************************************************************/
/** \brief Destruktor
*****************************************************************************/
EngineIO::~EngineIO()
{
delete (m_materialManager);
_instance = 0; // Singleton !!!
}

/*******************************************************************************
* Konstruktor - Singleton
*******************************************************************************/
  EngineIO::EngineIO()
  {
  m_camera           = Camera::getInstance();
  m_map              = Map::getInstance();
  m_materialManager  = MaterialManager::getInstance();
  m_lightManager     = LightManager::getInstance();
  m_skybox           = SkyBox::getInstance();
  m_animationManager = AnimationManager::getInstance();
  m_partikelManager  = PartikelManager::getInstance();
  m_textMapper       = TextMapper::getInstance();
  }

/******************************************************************************/
/** \brief Serialisiert alle Objekte in ein Binaerfile
    \param fname Pfad+Dateiname+Extension zur Binaerdatei
*******************************************************************************/
void EngineIO::save(char* fname)
{
  int i=0, size=0;
  
  try
    {
    DataOutputStream* dataOut = new DataOutputStream(fname);

    // --------------------------------------------------------------
    // ID-Signatur schreiben:
    // --------------------------------------------------------------
    int id = 721963;  dataOut->writeInt(id); 
    int version  = 1; dataOut->writeInt(version);
    
    // --------------------------------------------------------------
    // Texturen schreiben:
    // --------------------------------------------------------------    
    m_materialManager->save(*dataOut);
    
    // --------------------------------------------------------------
    // Tiles schreiben:
    // --------------------------------------------------------------    
    size = m_map->zoneList.size();
    dataOut->writeInt(size);    // Anzahl Tiles schreiben
    for (i=0; i < size; i++)
       {
       Zone* zone = m_map->zoneList[i];
       zone->save(*dataOut);
       }
    
    // --------------------------------------------------------------
    // Camera schreiben:
    // --------------------------------------------------------------    
    m_camera->save(*dataOut);

    // --------------------------------------------------------------
    // Light schreiben:
    // --------------------------------------------------------------    
    m_lightManager->save(*dataOut);

    // --------------------------------------------------------------
    // Skybox schreiben:
    // --------------------------------------------------------------    
    m_skybox->save(*dataOut);

    // --------------------------------------------------------------
    // AnimationPool schreiben:
    // --------------------------------------------------------------    
    m_animationManager->save(*dataOut);

    // --------------------------------------------------------------
    // Partikelsysteme schreiben:
    // --------------------------------------------------------------    
    m_partikelManager->save(*dataOut);

    // --------------------------------------------------------------
    dataOut->close();
    delete(dataOut);
    }
  catch (std::exception e)
    {
    printf("EOF" ); // TODO: Logfile schreiben
    }
}

/****************************************************************************/
/** \brief Liest die Mapdatei ein
*   \param mapfile Pfad+Dateiname+EXT der Mapdatei
*******************************************************************************/
bool EngineIO::load(char* mapfile)
{
  bool status = true;
  int i, size=0;

  m_materialManager->clear();

  // TODO: nach Map auslagern:
  for (i=0; i < (int)m_map->zoneList.size(); i++)
     {
     Zone* zone = m_map->zoneList[i];
     zone->tileList.clear();
     }
  m_map->zoneList.clear();

  try
    {
    DataInputStream* dataIn = new DataInputStream( mapfile );

    // --------------------------------------------------------------
    // ID-Signatur lesen:
    // --------------------------------------------------------------
    int id      = dataIn->readInt();
    int version = dataIn->readInt();
    if ((id != 721963) || (version != 1))
       { 
       dataIn->close();
       delete(dataIn);
       return (false);
       }
       
    // --------------------------------------------------------------
    // Texturen lesen:
    // --------------------------------------------------------------    
    m_materialManager->load(*dataIn);
    
    // --------------------------------------------------------------
    // Zonen lesen:
    // --------------------------------------------------------------    
    size = dataIn->readInt(); // Anzahl Zonen
    for (i=0; i < size; i++)
      {
      Zone* zone = new Zone();
      zone->load(*dataIn);
      m_map->zoneList.push_back(zone);
      }
    
    // --------------------------------------------------------------
    // Camera lesen:
    // --------------------------------------------------------------    
    m_camera->load(*dataIn);

    // --------------------------------------------------------------
    // Light lesen:
    // --------------------------------------------------------------    
    m_lightManager->load(*dataIn);

    // --------------------------------------------------------------
    // Skybox lesen:
    // --------------------------------------------------------------    
    m_skybox->load(*dataIn);

    // --------------------------------------------------------------
    // AnimationManager lesen:
    // --------------------------------------------------------------    
    m_animationManager->load(*dataIn);

    // --------------------------------------------------------------
    // Partikelsysteme lesen:
    // --------------------------------------------------------------    
    m_partikelManager->load(*dataIn);

    // --------------------------------------------------------------
    // TextMapper, bzw. Characterset lesen:
    // --------------------------------------------------------------    
    m_textMapper->load(*dataIn);

    dataIn->close();
    delete(dataIn);
    }
  catch (std::exception e)
    {
    status = false;
    printf("Fehler beim laden der Texturen"); // TODO: Logfile schreiben
    }

   return (status);
}

