#if !defined(ENGINEIO_H)
#define ENGINEIO_H

#include <vector>
#include <math.h>

#include "DataOutputStream.h"
#include "DataInputStream.h"

#include "TArc.h"
#include "Vec.h"
#include "Matrix.h"

#include "EngineIO.h"
#include "Camera.h"
#include "Tile.h"
#include "Map.h"

#include "LightManager.h"
#include "Frustum.h"
#include "TextureMapper.h"
#include "MaterialManager.h"
#include "SkyBox.h"

#include "Animation.h"
#include "AnimationManager.h"

#include "PartikelManager.h"
#include "TextMapper.h"

/****************************************************************************/
/** \class EngineIO
    \brief EngineIO
*****************************************************************************/
class EngineIO  
{
public:
   static EngineIO* getInstance();

private:
  static EngineIO* _instance;

protected:
   EngineIO();

public:
   virtual ~EngineIO();

private:
   Map*              m_map;
   MaterialManager*  m_materialManager;
   Camera*           m_camera;
   LightManager*     m_lightManager;
   SkyBox*           m_skybox;
   AnimationManager* m_animationManager;
   PartikelManager*  m_partikelManager;
   TextMapper*       m_textMapper; 

public:
   void save(char* fname);
   bool load(char* mapfile);
};
#endif // !defined(ENGINEIO_H)
