#include "stdafx.h"

#include <vector>

#include "Timer.h"
#include "LightManager.h"

#include "Zone.h"
#include "Tile.h"

#include "AnimationManager.h"

#include "Map.h"


// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#pragma warning( disable : 4996 )

Map* Map::_instance = 0;

/****************************************************************************/
/** \brief Liefert die Singleton-Instanz
    \return Pointer auf die Instanz
*****************************************************************************/
Map* Map::getInstance()
{
 if (_instance == 0) 
   _instance = new Map();
 return _instance;
}

/****************************************************************************/
/** \brief Destruktor
*****************************************************************************/
Map::~Map()
{
for (unsigned int n=0; n < zoneList.size(); n++)
   {
   Zone* zone = zoneList[n];
   delete (zone);
   }

zoneList.clear();

_instance = 0; // Singleton !!!
}

/*******************************************************************************
* Konstruktor - Singleton
*******************************************************************************/
Map::Map()
  {
  m_mapfile[0] = 0;
  }

/*******************************************************************************
* Setzt das Directional Light fuer alle Tiles 
*******************************************************************************/
void Map::calcAnimation()
{
AnimationManager* animationManager = AnimationManager::getInstance();

for (unsigned int i=0; i < zoneList.size() ; i++)
   {
   Zone* zone = zoneList[i];
   for (unsigned int n=0; n < zone->tileList.size() ; n++)
      {
      Tile* t = (Tile*) zone->tileList[n];
      if (t->m_animationID > 0)
         {
         t->m_animationID = animationManager->add(t->m_animationID);
//       Animation* animation = animationManager->get(t->m_animationID);
//       animation->runForwardWaitBackwardStop();
         }
      }
   }
}


/*******************************************************************************
* Setzt das Directional Light fuer alle Tiles 
*******************************************************************************/
void Map::calcLightMapGrid()
{
Timer t;
t.start();

LightManager* lightManager = LightManager::getInstance();

for (unsigned int i=0; i < zoneList.size() ; i++)
   {
   Zone* zone = zoneList[i];
   for (unsigned int n=0; n < zone->tileList.size() ; n++)
      {
      Tile* t = (Tile*) zone->tileList[n];
      lightManager->calcLightMapGrid(*t);
      }
   }
t.end();
}

/*******************************************************************************
* Setzt das Directional Light fuer alle Tiles 
*******************************************************************************/
void Map::calcLightMap()
{
Timer t;
t.start();
int count = 0;

LightManager* lightManager = LightManager::getInstance();

for (unsigned int i=0; i < zoneList.size() ; i++)
   {
   Zone* zone = zoneList[i];
   for (unsigned int n=0; n < zone->tileList.size() ; n++)
      {
      Tile* t = (Tile*) zone->tileList[n];
      if (t->m_hasLightMapGrid == true)
         {
         lightManager->calcLightMap(*t);
         if (t->m_hasLightMapGrid == true)
             count++;
         }
      }
   }

char msg[128];
sprintf(msg, "Map::calcLightMap (%d) ", count);
t.end();
}

/*******************************************************************************
*  
*******************************************************************************/
 void Map::dump()
{
/*
  int i;
  Tile t = null;

  for (i=1; i < tileList.size() ; i++)
     {
     t = (Tile) tileList.get(i);
     if (t.m_typ == Tile.FLOOR)
        System.out.println("Tile " +i + " FLOOR");
     else if (t.m_typ == Tile.WALL)
        System.out.println("Tile " +i + " WALL");
     else if (t.m_typ == Tile.PORTAL)
        System.out.println("Tile " +i + " PORTAL");
     }
*/
}

/*******************************************************************************
* Convenience Methode zum anlegen einer Tile in eine Zone
* @param tile Name der WALL (nur fuer Debug)
*******************************************************************************/
void Map::addTile(Tile* tile)
{
 for (unsigned int i=0; i < zoneList.size(); i++)
    {
    Zone* zone = zoneList[i];
    if (tile->m_zoneTHIS == zone->m_zone)
      {
      zone->tileList.push_back(tile);
      return;
      }
    }
 
 Zone* zone = new Zone(tile->m_zoneTHIS);
 zoneList.push_back(zone);
 zone->tileList.push_back(tile);
}
