#include "stdafx.h"

#include <vector>

#include "DataInputStream.h"
#include "DataOutputStream.h"
#include "Timer.h"
#include "LightManager.h"
#include "Tile.h"
#include "Map.h"

#include "Zone.h"

// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/****************************************************************************/
/** \brief Konstruktor
*****************************************************************************/
Zone::Zone()
{
m_zone = -1;
}

/****************************************************************************/
/** \brief Konstruktor
    \param zone ZonenNr, bzw ZonenID
*****************************************************************************/
Zone::Zone(int zone)
{
m_zone = zone;
}

/****************************************************************************/
/** \brief Destruktor. Loescht alle zugehoerigen Tiles
*****************************************************************************/
Zone::~Zone()
{
for (unsigned int i=0; i < tileList.size(); i++)
   {
   Tile* t =(Tile*)tileList[i];
   delete (t);
   }
}

/****************************************************************************/
/** \brief Fuegt eine Tile hinzu. Zone erhaelt die Besitzrechte und darf
           die Tiles auch loeschen!
    \param tile Pointer auf Tile
*****************************************************************************/
void Zone::addTile(Tile* tile)
{
tileList.push_back(tile);
}

/****************************************************************************/
/** \brief Liest das Zonen-Objekt aus dem Inputstream
*   \param dataIn DataInputStream
*******************************************************************************/
void Zone::load(DataInputStream& dataIn) 
{
try
   {
   m_zone = dataIn.readInt();
   int size = dataIn.readInt();
   for (int i=0; i < size; i++)
      {
      Tile* tile = new Tile();
      tile->load(dataIn);
      if (tile->m_textureID != 6666)
         tileList.push_back(tile);
      else
        delete (tile);
      }
   }
catch (std::exception eof)
   {
   printf("EOF" ); // TODO: Logfile schreiben
   }
}

/******************************************************************************/
/** \brief Serialisert das Zonen-Objekt in den Outputstream
    \param dataOut DataOutputStream
    \throws IOException 
*******************************************************************************/
void Zone::save(DataOutputStream& dataOut) 
{
int size = tileList.size();

dataOut.writeInt(m_zone);  // ZoneNr
dataOut.writeInt(size);    // Anzahl Tiles schreiben
for (int i=0; i < size; i++)
   {
   Tile* tile = (Tile*)tileList[i];
   tile->save(dataOut);
   }
}
