// LightMap.cpp: Implementierung der Klasse LightMap.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include <stdio.h>
#include <stdlib.h>

#ifdef WIN32
#include <malloc.h>
#endif

#include <string.h>

#include "LightMap.h"

// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#pragma warning( disable : 4996 )

/****************************************************************************/
/** \brief Destruktor
*****************************************************************************/
LightMap::~LightMap()
{
free (m_map);
}

/****************************************************************************/
/** \brief Konstruktor
           Achtung: Die Groesse der LightMap ist analog zu den Texturen auf 
           width * height Pixel festgelegt
    \param width  Breite der Lightmap
    \param height Hoeheder Lightmap
*****************************************************************************/
LightMap::LightMap(int width, int height)
{
m_len  = width * height;
m_width  = width;  // aka umax
m_height = height; // aka vmax
m_map = (BYTE*) malloc (m_width * m_height * sizeof(BYTE));
}

/****************************************************************************/
/** \brief Fuellt die Lightmap mit Defaultwerten (hier 0)
*****************************************************************************/
void LightMap::clear()
{
int i;
memset(m_map, 0, m_len * sizeof(BYTE));

for (i=0; i < m_len; i++)
   m_map[i] = 0;
}

/****************************************************************************/
/** \brief Getter fuer den max Wert in der Lightmap
    \return max. Wert
*****************************************************************************/
BYTE LightMap::getMax()
{
int i;
BYTE max=0;

for (i=0; i < m_len; i++)
   if (m_map[i] > max)
         max = m_map[i];

return (max);
}

/****************************************************************************/
/** \brief Obligatorische Dump-Methode fuer Debugzwecke
*****************************************************************************/
void LightMap::dump()
{
int u, v, index;

FILE *p = fopen ("c:\\LightMap.dump", "w");

if (p != 0)
   {
   int vc = m_height / 16;
   int uc = m_width  / 16;
   int u_, v_;

   for (v=0; v <= vc; v++)
      {
      v_ = 0;
      if (v != 0)
         v_ = (v * 16) -1;

      for (u=0; u <= uc; u++)
         {
         u_ = 0;
         if (u != 0)
            u_ = (u * 16) -1;

         index = (v_ * m_width) + u_; 
         fprintf(p, "%3d ", m_map[index]);
         }
      fprintf(p, "\n");
      }

   fprintf(p, "\n");

   for (v=0; v < m_height; v++)
      {
      for (u=0; u < m_width; u++)
         {
         index = (v * m_width) + u;
         fprintf(p, "%3d ", m_map[index]);
         }
      fprintf(p, "\n");
      }

   fclose(p);
   }
}

/****************************************************************************/
/** \brief Setter fuer die Lightmap
    \param u U-Koordinate auf der Lightmap
    \param v V-Koordinate auf der Lightmap
    \param value an der uv-Koordinate zu setzender Wert
*****************************************************************************/
void LightMap::set(int u, int v, BYTE value )
{
int index = (v * m_width) + u;
m_map[index]=value;
}
