#include "stdafx.h"

#include "Vec.h"
#include "LightPoint.h"

/****************************************************************************/
/** \brief Destruktor
*****************************************************************************/
LightPoint::~LightPoint()
{

}

/****************************************************************************/
/** \brief Konstruktor
*****************************************************************************/
LightPoint::LightPoint()
{
//m_pos = null;
xs = 50;   
ys = 0.5;
xe = 86;  
ye = 0.1f; 

init();
}

/****************************************************************************/
/** \brief Konstruktor mit Positonskoordinate im 3D-Raum
    \param posX
    \param posY
    \param posZ
*****************************************************************************/
LightPoint::LightPoint(float posX, float posY, float posZ)
{
xs = 50;   
ys = 0.5;
xe = 86;  
ye = 0.1f; 

init();
set( posX, posY, posZ);
}

/****************************************************************************/
/** \brief Allgemeine Initialisierung 
*****************************************************************************/
void LightPoint::init()
{
m_pos.clear(); // = new Vec();

float xs = 50;   
float ys = 0.5;
float xe = 86;  
float ye = 0.1f; 

calcParameters(xs, ys, xe, ye);
}

/****************************************************************************/
/** \brief Setter fuer die Positionskoordinate
    \param posX
    \param posY
    \param posZ
*****************************************************************************/
void LightPoint::set(float posX, float posY, float posZ)
{
m_pos.set(posX, posY, posZ);
}

/****************************************************************************/
/** \brief Berechnet einige Parameter
    \param xs
    \param ys
    \param xe
    \param ye
*****************************************************************************/
void LightPoint::calcParameters(float xs, float ys, float xe, float ye)
{
 this->xs = xs;   
 this->ys = ys;
 this->xe = xe;  
 this->ye = ye; 

 float z = ((xe*xe)/ys) - ((xs*xs)/ye);
 float n = ((xe*xe) - (xs*xs));
 c = z/n;

 float as = ((1.0f / ys) - c) / (xs*xs);
// float ae = ((1.0f / ye) - c) / (xe*xe);
 a = as;
}

/****************************************************************************/
/** \brief Berechnet den y Wert
    \param  x
    \return y
*****************************************************************************/
float LightPoint::calc(float x)
{
if (x < xs)
  return (ys);

float y = 1 / (a*x*x + c);
return (y);
}

/****************************************************************************/
/** \brief Getter fuer XS
    \return xs
*****************************************************************************/
float LightPoint::getXS() {return (xs);}

/****************************************************************************/
/** \brief Getter fuer YS
    \return ys
*****************************************************************************/
float LightPoint::getYS() {return (ys);}

/****************************************************************************/
/** \brief Getter fuer XE
    \return xe
*****************************************************************************/
float LightPoint::getXE() {return (xe);}

/****************************************************************************/
/** \brief Getter fuer YE
    \return ye
*****************************************************************************/
float LightPoint::getYE() {return (ye);}

/****************************************************************************/
/** \brief Obligtorische Dump-Methode fuer Debugzwecke
*****************************************************************************/
void LightPoint::dump()
{
/*
System.out.println("PointLight---------------------------");
System.out.println("Pos=" + m_pos.dump());
System.out.println("xs=" +  xs +  " ys=" + ys);
System.out.println("xe=" +  xe +  " ye=" + ye);
System.out.println("a="  +  a  +  " c=" + c);
System.out.println("-------------------------------------");
*/
}

/****************************************************************************/
/** \brief Dump-Methode fuer detailierte Debugausgaben
*****************************************************************************/
void LightPoint::dumpDiagram()
{
/*
System.out.println("PointLight---------------------------");
System.out.println("Pos=" + m_pos.dump());
System.out.println("xs=" +  xs +  " ys=" + ys);
System.out.println("xe=" +  xe +  " ye=" + ye);
System.out.println("a="  +  a  +  " c=" + c);

float x, y;
for (x=xs; x < xe; x+=1)
   {
   y = calc(x);
   System.out.println("PointLight x=" + x + " y= " + y);
   }

System.out.println("-------------------------------------");
*/
}
