#if !defined(LIGHTPOINT_H)
#define LIGHTPOINT_H

/****************************************************************************/
/** \class LightPoint
    \brief Klasse fuer ein Punktlicht
*****************************************************************************/
class LightPoint  
{
public:
   Vec m_pos;

private:
   float xs;   
   float ys;
   float xe;  
   float ye; 

   float c;
   float a;

public:
	LightPoint();
   LightPoint(float posX, float posY, float posZ);
	virtual ~LightPoint();

   void set(float posX, float posY, float posZ);
   void calcParameters(float xs, float ys, float xe, float ye);
   float calc(float x);
   float getXS(); 
   float getYS();
   float getXE();
   float getYE();
   void dump();
   void dumpDiagram();

private:
   void init();
};
#endif // !defined(LIGHTPOINT_H)
