#if !defined(LIGHTZONE_H)
#define LIGHTZONE_H

#include "Vec.h"
#include "LightPoint.h"

/****************************************************************************/
/** \class LightZone 
    \brief  Klasse fuer eine Zone:
            Es gibt nur eine Lichtumgebung pro Zone
            In einer Zone kann es nur ein Directional Light geben
            Eine Zone kann beliebig viele PointLights enthalten
*****************************************************************************/
class LightZone  
{
private:
   int   m_zone;
   float m_ambient;
   float m_directionalMax;
   float m_pointMax;

public:
   Vec m_dir;
   std::vector<LightPoint*> lightPointList;

public:
   LightZone(int zone);
   LightZone(int zone, float ambient, float directionalMax, float pointMax);
	virtual ~LightZone();

   void  set(float ambient, float directionalMax, float pointMax);
   void  setDirectionalLight(float dirX, float dirY, float dirZ);
   void  addPointLight(float posX, float posY, float posZ);
   int   getZone();
   float getAmbient();
   float getDirectionalMax();
   float getPointMax();
   bool  hasPointLights();
   void  dump();

private:
   void init(int zone);
};
#endif // !defined(LIGHTZONE_H)
