#include "stdafx.h"

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>

#include "Fixed.h"

#define FIX16_16
//#define FIX12_20

#ifdef FIX16_16

#define MUL_VAL 65536.0f
#define DIV_VAL 16

#else if FIX12_20

//#define MUL_VAL 32768.0f
//#define DIV_VAL 17

//#define MUL_VAL 16384.0f
//#define DIV_VAL 18

//#define MUL_VAL 8192.0f
//#define DIV_VAL 19


#define MUL_VAL 131072.0f
#define DIV_VAL 15



#endif


/*****************************************************************************
*
*****************************************************************************/
FIXED float2fix(float f)
{
FIXED erg = (FIXED)(f * MUL_VAL);
return (erg);
}

/*****************************************************************************
*
*****************************************************************************/
float fix2float(FIXED i)
{
float erg = (float)(i) / MUL_VAL;
return (erg);
}

/*****************************************************************************
*
*****************************************************************************/
FIXED fixMul(FIXED a, FIXED b)
{
FIXED erg = (FIXED) (((__int64)a*b) >> DIV_VAL);
return (erg);
}

/*****************************************************************************
*
*****************************************************************************/
int fixDiv(FIXED a, FIXED b)
{
FIXED erg = (FIXED)(((__int64)a << DIV_VAL) / b);
return (erg);
}

/*****************************************************************************
*
*****************************************************************************/
void fixedtest(void)
{
float af, bf, cf;
FIXED ai, bi, ci;

af=3.4f;
bf=8.2f;
cf = af * bf;
printf("cf=%f\n", cf);

ai = float2fix(af);
bi = float2fix(bf);
ci = fixMul(ai, bi);
cf = fix2float(ci);
printf("cf=%f\n", cf);


af=1.0f;
bf=8.2f;
cf = af / bf;
printf("cf=%f\n", cf);

ai = float2fix(af);
bi = float2fix(bf);
ci = fixDiv(ai, bi);
cf = fix2float(ci);
printf("cf=%f\n", cf);
}