#include "stdafx.h"

#include "Vec.h"

#include "Line.h"

// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/****************************************************************************/
/** \brief Konstruktor
*****************************************************************************/
Line::Line()
{
  m_S; // = new Vec();
  m_V; // = new Vec();
}

/****************************************************************************/
/** \brief Destruktor
*****************************************************************************/
Line::~Line()
{

}

/****************************************************************************/
/** \brief Setter fuer die Lineeigenschaften
    \param p1 Erster Punkt bzw. Startpunkt der Linie
    \param p2 Zweiter Punkt bzw. Endpunkt der Linie
*****************************************************************************/
void Line::set(Vec& p1, Vec& p2)
  {
  m_S.set(p1);
  m_V.sub(p2, p1);
  }

/****************************************************************************/
/** \brief Getter fuer die Linienlaenge
    \return Laenge der Linie
*****************************************************************************/
float Line::getLength()
  {
  return (m_V.length());
  }

/****************************************************************************/
/** \brief Getter fuer den Endpunkt der Linie. Es gilt: P(t) = S + t*V
    \param t --> Len
    \return Punktvektor
*****************************************************************************/
Vec* Line::getEndPoint(float t)
  {
  Vec* E = new Vec(m_V); // TODO: Achtung potentiell ein Speicherleck!!!
  
  E->mul(t);
  E->add(m_S);

  return (E);
  }

/****************************************************************************/
/** \brief Getter fuer den Endpunkt der Linie. Es gilt: P(t) = S + t*V
    \param t --> Len
    \param E --> Punktvektor
*****************************************************************************/
void Line::getEndPoint(float t, Vec* E)
  {
  E->set(m_V); 
  
  E->mul(t);
  E->add(m_S);
  }

/****************************************************************************/
/** \brief Getter fuer den Endpunkt der Linie. Es gilt: P(t) = S + t*V
    \param t --> Len
    \return Punktvektor
*****************************************************************************/
Vec& Line::getEndPoint2(float t)
  {
  m_E.set(m_V); 
  
  m_E.mul(t);
  m_E.add(m_S);

  return (m_E);
  }

/****************************************************************************/
/** \brief Obligatorische Dump-Methode fuer Debugzwecke
*****************************************************************************/
void Line::dump(char* msg)
  {
  msg; // makes compiler happy
//  System.out.println(msg + " Line.m_S=" + m_S.dump()  + 
//                           " Line.m_V=" + m_V.dump());

//  printf("%s", msg);
  }
