#include "stdafx.h"

#include <math.h>

#include "TArc.h"

#include "Matrix.h"
#include "Vec.h"

// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/****************************************************************************/
/** \brief Konstruktor
*****************************************************************************/
Matrix::Matrix()
{
  m_arc = TArc::getInstance();
  clear();
}

/****************************************************************************/
/** \brief Destruktor
*****************************************************************************/
Matrix::~Matrix()
{
}

/****************************************************************************/
/** \brief Initialisiert die Matrix
*****************************************************************************/
void Matrix::clear()
   {
   m_11=1; m_12=0; m_13=0; m_14=0;
   m_21=0; m_22=1; m_23=0; m_24=0;
   m_31=0; m_32=0; m_33=1; m_34=0;
   m_41=0; m_42=0; m_43=0; m_44=1;
   }

/****************************************************************************/
/** \brief Setter fuer die Matrix
    \param v1
    \param v2
    \param v3
*****************************************************************************/
void Matrix::set(Vec& v1, Vec& v2, Vec& v3)
  {
  m_11=v1.m_x; m_12=v2.m_x; m_13=v3.m_x; m_14=0;
  m_21=v1.m_y; m_22=v2.m_y; m_23=v3.m_y; m_24=0;
  m_31=v1.m_z; m_32=v2.m_z; m_33=v3.m_z; m_34=0;
  m_41=0;      m_42=0;      m_43=0;      m_44=1;
  }

/****************************************************************************/
/** \brief Invertiert die Matrix
    \param v1
    \param v2
    \param v3
*****************************************************************************/
void Matrix::setInv(Vec& v1, Vec& v2, Vec& v3)
  {
  m_11=v1.m_x; m_12=v1.m_y; m_13=v1.m_z; m_14=0;
  m_21=v2.m_x; m_22=v2.m_y; m_23=v2.m_z; m_24=0;
  m_31=v3.m_x; m_32=v3.m_y; m_33=v3.m_z; m_34=0;
  m_41=0;      m_42=0;      m_43=0;      m_44=1;
  }

/****************************************************************************/
/** \brief Bildet die Matrix zu einer Rotation um die X Achse
    \param w Winkel (in Grad !!!)
*****************************************************************************/
void Matrix::rotateX(int w)
   {
   float cos = m_arc->getCos(w);
   float sin = m_arc->getSin(w);

   m_11=1; m_12=0;    m_13=0;    m_14=0;
   m_21=0; m_22=cos;  m_23=sin;  m_24=0;
   m_31=0; m_32=-sin; m_33=cos;  m_34=0;
/* m_41=0; m_42=0;    m_43=0; */ m_44=1;
   }

/****************************************************************************/
/** \brief Bildet die Matrix zu einer Rotation um die Y Achse
    \param w Winkel (in Grad !!!)
*****************************************************************************/
void Matrix::rotateY(int w)
   {
   float cos = m_arc->getCos(w);
   float sin = m_arc->getSin(w);

   m_11=cos; m_12=0; m_13=-sin; m_14=0;
   m_21=0;   m_22=1; m_23=0;    m_24=0;
   m_31=sin; m_32=0; m_33=cos;  m_34=0;
/* m_41=0;   m_42=0; m_43=0; */ m_44=1;
   }

/****************************************************************************/
/** \brief Bildet die Matrix zu einer Rotation um die Z Achse
    \param w Winkel (in Grad !!!)
*****************************************************************************/
void Matrix::rotateZ(int w)
   {
   float cos = m_arc->getCos(w);
   float sin = m_arc->getSin(w);

   m_11=cos;  m_12=sin;  m_13=0;   m_14=0;
   m_21=-sin; m_22=cos;  m_23=0;   m_24=0;
   m_31=0;    m_32=0;    m_33=1;   m_34=0;
/* m_41=0;    m_42=0;    m_43=0;*/ m_44=1;
   }

/****************************************************************************/
/** \brief Bildet die Matrix zu einer Rotation um die X Achse
    \param w Winkel (in Rad !!!)
*****************************************************************************/
void Matrix::rotateXRad(float w)
   {
   float cos_ = (float)cos(w);
   float sin_ = (float)sin(w);

   m_11=1; m_12=0;     m_13=0;     m_14=0;
   m_21=0; m_22=cos_;  m_23=sin_;  m_24=0;
   m_31=0; m_32=-sin_; m_33=cos_;  m_34=0;
/* m_41=0; m_42=0;     m_43=0; */  m_44=1;
   }

/****************************************************************************/
/** \brief Bildet die Matrix zu einer Rotation um die Y Achse
    \param w Winkel (in Rad !!!)
*****************************************************************************/
void Matrix::rotateYRad(float w)
   {
   float cos_ = (float)cos(w);
   float sin_ = (float)sin(w);

   m_11=cos_; m_12=0; m_13=-sin_; m_14=0;
   m_21=0;    m_22=1; m_23=0;     m_24=0;
   m_31=sin_; m_32=0; m_33=cos_;  m_34=0;
/* m_41=0;    m_42=0; m_43=0; */  m_44=1;
   }

/****************************************************************************/
/** \brief Bildet die Matrix zu einer Rotation um die Z Achse
    \param w Winkel (in Rad !!!)
*****************************************************************************/
void Matrix::rotateZRad(float w)
  {
  float cos_ = (float)cos(w);
  float sin_ = (float)sin(w);

  m_11=cos_;  m_12=sin_;  m_13=0;   m_14=0;
  m_21=-sin_; m_22=cos_;  m_23=0;   m_24=0;
  m_31=0;     m_32=0;     m_33=1;   m_34=0;
/*m_41=0;     m_42=0;     m_43=0;*/ m_44=1;
  }

/****************************************************************************/
/** \brief Bildet eine Translationsmatrix
    \param v Vector
*****************************************************************************/
void Matrix::translate(Vec& v)
   {
   m_41=v.m_x; m_42=v.m_y; m_43=v.m_z;
   }

/****************************************************************************/
/** \brief Skaliert die Matrix
    \param s Skalierungswert
*****************************************************************************/
void Matrix::scale(float s)
   {
   m_11 = s; m_22 = s; m_33 *= s; m_44=1;
   }

/****************************************************************************/
/** \brief Obligatorische Dump-Methode fuer Debugzwecke
*****************************************************************************/
void Matrix::dump()
  {
  }

