#if !defined(PLANE_H)
#define PLANE_H

#include "Vec.h"
#include "Line.h"

/****************************************************************************/
/** \class Plane
    \brief Plane
*****************************************************************************/
class Plane  
{
public:
	Plane();
	virtual ~Plane();

   enum PLANE_TYPE {INSIDE=0, OUTSIDE=1, INPLANE=2};
  
   Vec m_N;    // Normalenvektor zur Ebene
   Vec m_P;    // Punkt auf der Ebene
   float m_D;  // Entfernung zum Ursprung

private:  
   float m_intersectLength;

public:
   void  clear(void); 
   void  set(Vec& v0, Vec& va, Vec& vb);
   int   check(Vec& v0);
   bool  intersect(Line& P, float* dist);
   float getInterLegth()  ;
   void  dump(char* msg);
};
#endif // !defined(PLANE_H)
