// TArc.cpp: Implementierung der Klasse TArc.
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include <math.h>

#include "TArc.h"

// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

TArc* TArc::_instance = 0;

/****************************************************************************/
/** \brief Liefert die Singleton-Instanz
    \return Pointer auf die Instanz
*****************************************************************************/
TArc* TArc::getInstance()
{
 if (_instance == 0) 
   _instance = new TArc();
 return _instance;
}


/****************************************************************************/
/** \brief Konstruktor
*****************************************************************************/
TArc::TArc()
{
   arc360 = 360;
   arc180 = 180;
   
//   m_sin = new float[arc360 + 1];
//   m_cos = new float[arc360 + 1];
//   m_tan = new float[arc360 + 1];
   
   int i;
   for (i=0; i<=arc360; i++)
      {
      m_sin[i] = (float)sin(grad2rad((float)i));
      m_cos[i] = (float)cos(grad2rad((float)i));
      m_tan[i] = (float)tan(grad2rad((float)i));
     }

}

/****************************************************************************/
/** \brief Destruktor
*****************************************************************************/
TArc::~TArc()
{
_instance = 0; // Singleton !!!
}

/*******************************************************************************
* Gibt den sin-Wert zurueck
* @param w Winkel Grad (0 - 360) * f !!!
* @return sin-Wert [Grad]
*******************************************************************************/
 float TArc::getSin(int w)  {  return (m_sin[w]);  }

/*******************************************************************************
* Gibt den cos-Wert zurueck
* @param w Winkel Grad (0 - 360) * f !!!
* @return cos-Wert [Grad]
*******************************************************************************/
 float TArc::getCos(int w)  {  return (m_cos[w]);  }

/*******************************************************************************
* Gibt den tan zurueck
* @param w Winkel Grad (0 - 360) * f !!!
* @return tan-Wert [Grad]
*******************************************************************************/
 float TArc::getTan(int w)  {  return (m_tan[w]);  }

/*******************************************************************************
* Normiert einen Winkel zwischen '0' und '360' Grad
* @param w Eingangswinkel
* @return normierter Winkel
*******************************************************************************/
 int TArc::norm(int w)
  {
  int erg = w;

  if (w >= arc360)
      erg = w - arc360;
  else if (w < 0)
      erg = arc360 + w;

  return (erg);
  }

/*******************************************************************************
* Hilfsfunktion: Umwandlung rad->grad
* @param grad Winkel in [rad]
* @return Winkel in [grad]
*******************************************************************************/
 float TArc::grad2rad(float grad) { return ((3.14f * grad) / arc180);  }

