// Triangle.cpp: Implementierung der Klasse Triangle.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include <vector>

#include "MaterialManager.h"
#include "Triangle.h"

// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


/*******************************************************************************
* Destruktor
*******************************************************************************/
Triangle::~Triangle()
{

}

/*******************************************************************************
* Konstruktor
*******************************************************************************/
  Triangle::Triangle()
  {
  m_xmax=0; // SkyBox
  m_ymax=0; // SkyBox

  m_textureID = 0;
  m_tex = 0;

  m_ambientLight = 1;
  m_directionalLight = 0;
  m_lightMap = 0;
  m_alpha = -1;
  }

/*******************************************************************************
* set
*******************************************************************************/
void Triangle::set(int textureID, Vec& v0, Vec& v1, Vec& v2)
    {
    m_textureID = textureID;


    MaterialManager* tp = MaterialManager::getInstance();
    m_tex = tp->get(m_textureID);
    
    m_alpha = m_tex->getAlpha();

    m_xmax  = m_tex->getWidth()  - 2; // !!!!!! -1 !!!!!! SkyBox
    m_ymax  = m_tex->getHeight() - 2; // !!!!!! -1 !!!!!! SkyBox

    m_p0.set(v0);
    m_p1.set(v1);
    m_p2.set(v2);
    }  

/*******************************************************************************
* dump
*******************************************************************************/
void Triangle::dump()
   {

   }
  
