#if !defined(TRIANGLE_H)
#define TRIANGLE_H

#include "Tile.h"
#include "Texture.h"
#include "Lightmap.h"

class Tile;

/****************************************************************************/
/** \class Triangle
    \brief Triangle
*****************************************************************************/
class Triangle  
{
public:
   Vec m_p0;    // Eckpunkte des Dreiecks im 3D-Raum
   Vec m_p1;
   Vec m_p2;

   float x[3];  // x0' (projiziert auf Plane)
   float y[3];  // y0' (projiziert auf Plane)
   float z[3];  // z0-Koordinate (im Raum)
   float c[3];  // c0 ==> 1/z0-Koordinate (im Raum)
   float uc[3]; // u * c0 (u Texelkoordinate in x-Richtung)
   float vc[3]; // v * c0 (v Texelkoordinate in y-Richtung)


   float m_u0;  // Eckpunkte der Texture
   float m_v0;  

   float m_u1;
   float m_v1;

   float m_u2;
   float m_v2;

   int m_xmax; 
   int m_ymax; 
   int m_alpha;

   long m_sid;
   int   m_textureID;
   Texture* m_tex;

   float m_ambientLight;
   float m_directionalLight;
   LightMap*  m_lightMap;

public:
	Triangle();
	virtual ~Triangle();

   void set(int textureID, Vec& v0, Vec& v1, Vec& v2);
   void dump();
};
#endif // !defined(TRIANGLE_H)
