#include "stdafx.h"

#include <math.h>

#include "TArc.h"

#include "Matrix.h"
#include "Vec.h"

// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/****************************************************************************/
/** \brief Destruktor
*****************************************************************************/
Vec::~Vec()
{

}

/****************************************************************************/
/** \brief Konstruktor
*****************************************************************************/
Vec::Vec()
  {
  m_x = 0;
  m_y = 0;
  m_z = 0;
  }

/****************************************************************************/
/** \brief Konstruktor
    \param v Vektor
*****************************************************************************/
Vec::Vec(Vec& v)
  {
  m_x = v.m_x;
  m_y = v.m_y;
  m_z = v.m_z;
  }

/****************************************************************************/
/** \brief Konstruktor
    \param x X-Koordinate
    \param y Y-Koordinate
    \param z Z-Koordinate
*****************************************************************************/
Vec::Vec(int x, int y, int z)
  {
  m_x = (float)x;
  m_y = (float)y;
  m_z = (float)z;
  }

/****************************************************************************/
/** \brief Konstruktor
    \param x X-Koordinate
    \param y Y-Koordinate
    \param z Z-Koordinate
*****************************************************************************/
Vec::Vec(float x, float y, float z)
  {
  m_x = x;
  m_y = y;
  m_z = z;
  }

/****************************************************************************/
/** \brief Setzt den Vektor auf 0,0,0
*****************************************************************************/
void Vec::clear()
  {
  m_x = 0;
  m_y = 0;
  m_z = 0;
  }

/****************************************************************************/
/** \brief Setter-Methode
    \param x X-Koordinate
    \param y Y-Koordinate
    \param z Z-Koordinate
*****************************************************************************/
void Vec::set(float x, float y, float z)
  {
  m_x = x;
  m_y = y;
  m_z = z;
  }

/****************************************************************************/
/** \brief Setter-Methode
    \param v Vektor 
*****************************************************************************/
void Vec::set(Vec& v)
  {
  m_x = v.m_x;
  m_y = v.m_y;
  m_z = v.m_z;
  }

/****************************************************************************/
/** \brief Vektoraddition
    \param v Vektor
*****************************************************************************/
void Vec::add(Vec& v)
  {
  m_x += v.m_x;
  m_y += v.m_y;
  m_z += v.m_z;
  }

/****************************************************************************/
/** \brief Vektorsubtraktion
    \param v Vektor
*****************************************************************************/
void Vec::sub(Vec& v)
  {
  m_x -= v.m_x;
  m_y -= v.m_y;
  m_z -= v.m_z;
  }

/****************************************************************************/
/** \brief Vektorsubtraktion: v = v1 - v2
    \param v1 Vektor
    \param v2 Vektor
*****************************************************************************/
void Vec::sub(Vec& v1, Vec& v2)
  {
  m_x = v1.m_x - v2.m_x;
  m_y = v1.m_y - v2.m_y;
  m_z = v1.m_z - v2.m_z;
  }

/****************************************************************************/
/** \brief Vektormultiplikation
    \param v Vektor
*****************************************************************************/
void Vec::mul(Vec& v)
  {
  m_x *= v.m_x;
  m_y *= v.m_y;
  m_z *= v.m_z;
  }

/****************************************************************************/
/** \brief Vektordivision mit einem Skalar
    \param v float-Wert
*****************************************************************************/
void Vec::div(float v)
   {
   m_x /= v;
   m_y /= v;
   m_z /= v;
   }
  
/****************************************************************************/
/** \brief Skalarmultiplikation (velaengert oder verkuerzt den Vektor)
    \param d float Wert
*****************************************************************************/
void Vec::mul(float d)
  {
  m_x = m_x * d;
  m_y = m_y * d;
  m_z = m_z * d;
  }

/****************************************************************************/
/** \brief Ermittelt die Laenge (Betrag) des Vektors
    \return Laenge, bzw. Distanz zum Ursprung
*****************************************************************************/
float Vec::length()
  {
  return ((float)sqrt(m_x*m_x + m_y*m_y + m_z*m_z));
  }

/****************************************************************************/
/** \brief Dotprodukt
    \param v Vektor
*****************************************************************************/
float Vec::dot(Vec& v)
  {
  return (v.m_x*m_x + v.m_y*m_y +v.m_z*m_z);
  }

/****************************************************************************/
/** \brief Kreuzprodukt v = v1 x v2
    \param v1 Vektor #1
    \param v2 Vektor #2
*****************************************************************************/
void Vec::cross(Vec& v1, Vec& v2)
  {
  m_x = v1.m_y * v2.m_z - v1.m_z * v2.m_y;
  m_y = v1.m_z * v2.m_x - v1.m_x * v2.m_z;
  m_z = v1.m_x * v2.m_y - v1.m_y * v2.m_x;
  }
 
/****************************************************************************/
/** \brief Berechnet den Punkt zwischen den Vektoren an z
    \param a Startpunkt, bzw. Startvektor
    \param b Startpunkt, bzw. Startvektor
    \param z Startpunkt, bzw. Startvektor
    \return true-->Es gibt einen Scnittpunkt mit z
            false-->Er gibt keinen Schnittpunkt mit z
*****************************************************************************/
bool Vec::getZ(Vec& a, Vec& b, float z)
   {
   if ((a.m_z < z) && (b.m_z < z))
      return (false);

   if ((a.m_z > z) && (b.m_z > z))
      return (false);
   
   // TODO: Optimieren 
   m_x = ((a.m_x - b.m_x) / (a.m_z - b.m_z)) * (z - b.m_z) + b.m_x;
   m_y = ((a.m_y - b.m_y) / (a.m_z - b.m_z)) * (z - b.m_z) + b.m_y;
   m_z = z;
   
   return (true);
   }
 
/****************************************************************************/
/** \brief Winkel zwischen zwei Vektoren
    \param v Vektor
    \return Winkel
*****************************************************************************/
float Vec::angle(Vec& v)
  {
  return ((float)(acos(this->dot(v) / (this->length() * v.length()))));
  }

/****************************************************************************/
/** \brief Winkel 
    \return Winkel 
*****************************************************************************/
int Vec::winkel()
  {
  Vec v;
  v.set(*this);
  v.m_x = 0;
  v.m_z = 1;

  float ang = this->angle(v);
  ang = (180.0f / 3.14f) * ang;
  if (this->m_x < 0)
     ang = 360 - ang;

  return ((int)ang);
  }

/****************************************************************************/
/** \brief Fuehre die in der Matrix abgelegten Rechenoperationen auf diesen 
           Vektor aus. Achtung: erst Rotation dann Transformation !!!!!!!!

    \param mat Matrix
*****************************************************************************/
void Vec::transform(Matrix& mat)
  {
  float x = m_x*mat.m_11 + m_y*mat.m_21 + m_z*mat.m_31 + mat.m_41;
  float y = m_x*mat.m_12 + m_y*mat.m_22 + m_z*mat.m_32 + mat.m_42;
  float z = m_x*mat.m_13 + m_y*mat.m_23 + m_z*mat.m_33 + mat.m_43;
  float w = m_x*mat.m_14 + m_y*mat.m_24 + m_z*mat.m_34 + mat.m_44;

  m_x = x  / w;
  m_y = y  / w;
  m_z = z  / w;
  w = 1;
  }

/****************************************************************************/
/** \brief Normalisieren (Betrag=1)
*****************************************************************************/
void Vec::normalize()
  {
  float len = (float)sqrt(m_x*m_x + m_y*m_y + m_z*m_z);
  if (len != 0)
    {
    m_x /=len;
    m_y /=len;
    m_z /=len;
    }
  }

/****************************************************************************/
/** \brief Negiert den Vektor (Richtungsumkehr)
*****************************************************************************/
void Vec::negative()
  {
    m_x = -m_x;
    m_y = -m_y;
    m_z = -m_z;
  }

/****************************************************************************/
/** \brief Rotation um die X-Achse (Richtung der Horizontalen)
           Der Winkel wird in Grad angegeben, weil die trigonometrischen 
           Funktionen ueber Tabellen implementiert sind (Performanz!)
           Fuer w > 0: Neigung nach unten

    \param w Winkel
*****************************************************************************/
void Vec::rotateX(int w)
  {
  TArc* arc = TArc::getInstance(); 
  float sin_wi = arc->getSin (w);
  float cos_wi = arc->getCos (w);

  float y = ( m_y * cos_wi - m_z * sin_wi);
  float z = ( m_y * sin_wi + m_z * cos_wi);
  m_y=y;
  m_z=z;
  }

/****************************************************************************/
/** \brief Rotation um die Y-Achse (Hoehenachse), Fuer w > 0: Bei der 
           Draufsicht (auf den 3D-Raum) wird im Uhrzeigersinn gedreht
    \param w Winkel
*****************************************************************************/
void Vec::rotateY(int w)
  {
  TArc* arc = TArc::getInstance(); 
  float sin_wi = arc->getSin (w);
  float cos_wi = arc->getCos (w);

  float z= (m_z * cos_wi - m_x * sin_wi);
  float x= (m_z * sin_wi + m_x * cos_wi);
  m_z=z;
  m_x=x;
  }

/****************************************************************************/
/** \brief Rotation um die Z-Achse (zeigt in den Raum hinein)
           Fuer w>0: Bei der Ansicht von vorne (in den 3D-Raum hinein),
           wird gegen den Uhrzeigersinn gedreht
    \param w Winkel
*****************************************************************************/
void Vec::rotateZ(int w)
  {
  TArc* arc = TArc::getInstance(); 
  float sin_wi = arc->getSin (w);
  float cos_wi = arc->getCos (w);

  float x = ( m_x * cos_wi - m_y * sin_wi);
  float y = ( m_x * sin_wi + m_y * cos_wi);
  m_x=x;
  m_y=y;
  }

/****************************************************************************/
/** \brief Gibt den Winkel zurueck
    \return Winkel
*****************************************************************************/
int Vec::getWinkelY()
{
  float w = 0;
  int ww = 0;

  if (m_x == 0)
     {
     if (m_z > 0)
        ww = 0;
     else
        ww = 180;
     }
  else
     {
     float  q = (float)m_x / (float)m_z;
     float qq =  (float)atan(q);
     w = (qq * 180.0f) / 3.14f;
     ww = (int)w;

     if ((m_x < 0) && (m_z >= 0))
        ww = ww + 0;
     else if ((m_x < 0) && (m_z < 0))
        ww = ww + 180;
     else if ((m_x > 0) && (m_z < 0))
        ww = ww + 360;
     }

  return (ww);
}

/****************************************************************************/
/** \brief Obligatorische Dump-Methode fuer Debugzwecke
    \return String  
*****************************************************************************/
char* Vec::dump()
  {
  static char buf[100]; buf[0] = 0; // TODO: Zuviel Speicher ????
//  sprintf(buf, "%lf %lf %lf", m_x, m_y, m_z);
  return (buf); // Fehler !!!!!!!!!!
  }
