#if !defined(VEC_H)
#define VEC_H

class Matrix;

/****************************************************************************/
/** \class Vec 
    \brief 3D-Vektor (Linkshaendiges Koordinatensystem)

     Kamerasicht: x zeigt nach RECHTS
                  y zeigt nach OBEN
                  z zeigt vom Betrachter weg (in die TIEFE)

     Draufsicht auf die Map: x zeigt nach RECHTS (OSTEN)
                             y zeigt in die HOEHE (NORDEN)
                             z zeigt zum Betrachter (nach OBEN)
*****************************************************************************/
class Vec  
{
public:
   float m_x;
   float m_y;
   float m_z;

	Vec();
	virtual ~Vec();

   Vec(Vec& v);
   Vec(int x, int y, int z);
   Vec(float x, float y, float z);

   void  clear(void);
   void  set(float x, float y, float z);
   void  set(Vec& v);

   void  add(Vec& v);
   void  sub(Vec& v);
   void  sub(Vec& v1, Vec& v2);
   void  mul(Vec& v);
   void  div(float v);
   void  mul(float d);
   float length(void);
   float dot(Vec& v);
   void  cross(Vec& v1, Vec& v2);
   bool  getZ(Vec& a, Vec& b, float z);
   float angle(Vec& v);
   int   winkel(void);
   void  transform(Matrix& mat);
   void  normalize(void);
   void  negative(void);
   void  rotateX(int w);
   void  rotateY(int w);
   void  rotateZ(int w);

   int   getWinkelY(void);

   char* dump(void);
};
#endif // !defined(VEC_H)
