#include "stdafx.h"
#include <math.h>

#include "Object2D.h"

// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/****************************************************************************/
/** \brief Konstruktor
*****************************************************************************/
Object2D::Object2D() 
{
m_scale = 1;
m_scaleEnable = true;
}

/****************************************************************************/
/** \brief Destruktor
*****************************************************************************/
Object2D::~Object2D()
{
}

/****************************************************************************/
/** \brief Setter fuer die Position des Objektes im 3D-Raum 
           (Mittelpunk des Objektes)
    \param vec Position
*****************************************************************************/
void Object2D::setPos(Vec& vec)
{
m_startPosOrg.set(vec);
}

/****************************************************************************/
/** \brief Setter fuer die Eigenschaft Scaleable
    \param scaleEnable true, false
*****************************************************************************/
void Object2D::scaleEnable(bool scaleEnable)
{
m_scaleEnable = scaleEnable;
}

/****************************************************************************/
/** \brief Setter fuer den scale faktor
    \param scale Faktor
*****************************************************************************/
void Object2D::setScale(float scale)
{
m_scale = scale;
}

/****************************************************************************/
/** \brief Orignalausdehnung des Objektes (typ wie die Sprite)
    \param width  Breite
    \param height Hoehe
*****************************************************************************/
void Object2D::setSize(float width, float height)
{
m_width  = width;
m_height = height;
}

/****************************************************************************/
/** \brief Transformiert das Objekt im 3D Raum
    \param matTranslate Translationsmatrix
    \param matRotate    Rotationsmatrix
*****************************************************************************/
void Object2D::transform(Matrix& matTranslate, Matrix& matRotate)
  {
  m_pos.set(m_startPosOrg);
  m_pos.transform(matTranslate);
  m_pos.transform(matRotate);
  }

/****************************************************************************/
/** \brief Projiziert das Objekt aus dem 3D-Raum auf die 2D Ebene
           (Es werden die uv-Koordinaten der Eckpunkte projiziert)
    \param nearDist 
    \param farDist  
    \return true  
*****************************************************************************/
bool Object2D::project(float nearDist, float farDist) 
{
   float x = m_pos.m_x;
   float y = m_pos.m_y;
   float z = m_pos.m_z;

   float w_halbe = m_width  / 2.0f;
   float h_halbe = m_height / 2.0f;

   float q = (float)fabs(nearDist / z);

   //                                               +u
   //                                               |     +
   //                                               |      (0,0)
   // Achtung: Projektion in die Camera bedeutet:   |------------- +v

   m_u = (q * x);  // U-Koordinate (Mittelpunkt des 2D-Objektes)
   m_v = (q * y);  // V-Koordinate (Mittelpunkt des 2D-Objektes)
   
   if (m_scaleEnable == true)
      {
      m_u0 = q * (x - w_halbe * m_scale); // Oben links
      m_v0 = q * (y + h_halbe * m_scale);

      m_u1 = q * (x + w_halbe * m_scale); // Oben Rechts
      m_v1 = q * (y + h_halbe * m_scale);

      m_u2 = q * (x + w_halbe * m_scale); // Unten Rechts
      m_v2 = q * (y - h_halbe * m_scale);

      m_u3 = q * (x - w_halbe * m_scale); // Unten Links
      m_v3 = q * (y - h_halbe * m_scale);
      }
   else
      {
      m_u0 = m_u - w_halbe; // Oben links
      m_v0 = m_v + h_halbe;

      m_u1 = m_u + w_halbe; // Oben Rechts
      m_v1 = m_v + h_halbe;

      m_u2 = m_u + w_halbe; // Unten Rechts
      m_v2 = m_v - h_halbe;

      m_u3 = m_u - w_halbe; // Unten Links
      m_v3 = m_v - h_halbe;
      } 

   return (true);
}
