#if !defined(OBJECT2D_H)
#define OBJECT2D_H

#include "Vec.h"

/****************************************************************************/
/** \class Object2D
    \brief Beschreibt ein rechteckiges 2D-Objekt im 3D-Raum (typ. Sprites, 
           Partikel...)
*****************************************************************************/
class Object2D  
{
public:
	Object2D();
	virtual ~Object2D();

public:
  Vec m_startPosOrg; // Position im 3D-Raum
  float m_height;    // Hoehe  des 2D-Objektes
  float m_width;     // Breite des 2D-Objektes
  bool  m_scaleEnable; 

  // Parameter zur 2D-Projektion:
  Vec m_pos;  // Position in 3D-Raum transformiert zur Camera

  float m_u;  // Punkt Mitte
  float m_v;
  
  float m_u0; // Punkt oben links
  float m_v0;  

  float m_u1; // Punkt oben rechts
  float m_v1;  

  float m_u2; // Punkt unten rechts
  float m_v2;  

  float m_u3; // Punkt unten links
  float m_v3;  

  float m_scale;

public:
 void setPos(Vec& vec);
 void setSize(float width, float height);
 void scaleEnable(bool scaleEnable);
 void setScale(float scale);

 void transform(Matrix& matTranslate, Matrix& matRotate);
 bool project (float nearDist, float farDist);
};
#endif // !defined(OBJECT2D_H)
