#if !defined(PARTIKEL_H)
#define PARTIKEL_H

#include "Object2D.h"
#include "Sprite.h"

/****************************************************************************/
/** \class Partikel
    \brief Partikel werden fuer die Darstellung von Feuer, Rauch, Funken, 
           Regen usw. verwendet. Typ. wird ein Partikel durch ein 2D-Objekt 
           repraesentiert, dem eine semitransparente Bitmap (hier Sprite 
           genannt) fuer die Darstellung zugeordnet ist. Partikel koennen
           sich bewegen oder auch stationaer zein (Blinklichter). Sie haben 
           eine Emitter, einen Lebenszyklus und noch ein paar weitere Attribute.
           Um 'realistische' Bewegungsablaeufe zu simulieren, wird stark mit
           Zufallswerten gearbeitet. 

Bewegung:

- Keine Bewegung: Permanent AN, Blinkend=f(zeitintervall)
- Lineare Bewegung: Ueber die Zeit, oder ueber die Distanz zum Emitter
  Bei Erreichen des Ende: Dead(Ausblenden), Respawn am Emitter, Respawn 
  am letzter Position mit Richtungsumkehr
- Parabel (z.B. Granatenwurf): Ueber die Zeit, ueber die Strecke)

Bei linearer Bewegung:
- Bewegung innerhalb einer BBox (ggf, mit Reflexion)
- Bewegung innerhalb eines Zylinders (ggf, mit Reflexion)  
- Bewegung innerhalb einer Kugel (ggf, mit Reflexion)  

- Bewegung auf einer BBox (Anwendungsfall??)
- Bewegung auf einem Zylinders (Beamer von Startrek)  
- Bewegung auf einer Kugel (Kreis)  

*****************************************************************************/
class Partikel : public Object2D 
{
public:

   // Wenn Lifetime abgelaufen oder BOUNDING:
   enum ACTION {RESPAWN_AT_EMITTER=0, // Am Ursprung des Partikelsystems (kann sich bewegen!!) 
                NO_RESPAWN=1,         // ist Dead-->Ausblenden
                RESPAWN_REFLECTON=2   // Richtungsumkehr gemaess der BOUNDING, (NO_BOUNDING ==> Einfache Richtungsumkehr)
                };
   
   enum LIFECYCLE { IS_OFF     = 0, 
                    IS_ON      = 1,
                    SWITCH_OFF = 2, 
                    SWITCH_ON  = 3,
                    IS_DEAD    = 4
                  };

	Partikel(int zone, int action);
	virtual ~Partikel();

   void setMotion(Vec& startpos, Vec& velocity, Vec& force);
   void setMotion(Vec& startpos, Vec& randomMin, Vec& randomMax, float speed, Vec& force);

   void setONtime(int ontime);
   void setOFFtime(int offtime);

   float getONtime();
   void setFading(bool fading);
   void setROLLtime(int rolltime);
   
   void animate(void);
   bool isON(void);

   void addSprite(Sprite* sprite);
   void querySprite(void);

   bool m_isScale;
   bool m_isFading;

   Sprite* m_sprite;

private:
   void calcVelocity(void);
   int  refreshStatus(void);

   int   m_zone; 
   Vec   m_emitterPos; // Position des Emitters
   Vec   m_velocity;   // aktuelle Richtung- bzw. Geschwindigkeitsvektor  
   Vec   m_randomMin;
   Vec   m_randomMax;
   Vec   m_force;      // Kraftvektor, der auf das Partikel einwirkt (Wind, Gravitation)
   float m_frames;
   bool  m_useSpeed;
   float m_speed;

   unsigned long m_ONtime;  // Dauer der ON-Zeit (0 == Unendlich!!)
   unsigned long m_ONstart; // 

   unsigned long m_OFFtime; // Dauer der OFF-Zeit
   unsigned long m_OFFstart;

   unsigned long m_ROLLtime; 
   unsigned long m_ROLLstart;


   int m_status;
   int m_action; 

   int m_spriteCount;
   Sprite* m_spriteOrg[50];
   
   int m_currSpriteID;
};

#endif // !defined(PARTIKEL_H)
