#if !defined(PARTIKELMANAGER_H)
#define PARTIKELMANAGER_H

#include "Sprite.h"
#include "PartikelSystem.h"

/****************************************************************************/
/** \class PartikelManager
    \brief Muesste eigentlich PartikelSystemManger heissen. Es verwaltet alle 
           Partikelsysteme und alle Sprites, die fuer die Darstellung der 
           einzelnen Partikel gebraucht werden.
*****************************************************************************/
class PartikelManager  
{
public:
   static PartikelManager* getInstance();

private:
  static PartikelManager* _instance;

protected:
	PartikelManager();


public:
	virtual ~PartikelManager();

public:
  std::vector<Sprite*>         m_spriteList;
  std::vector<PartikelSystem*> m_partikelSystemList;

private:
  void clear(void);

public:
 void transform(Matrix& matTranslate, Matrix& matRotate);
 void project(float nearDist, float farDist);

 void load(DataInputStream& dataIn);
 void save(DataOutputStream& dataOut);
};

#endif // !defined(PARTIKELMANAGER_H)
