#if !defined(PARTIKELSYSTEM_H)
#define PARTIKELSYSTEM_H

#include "Partikel.h"
#include "Sprite.h" 

/****************************************************************************/
/** \class PartikelSystem
    \brief Ein Partikelsystem beschreibt das Verhalten von Partikeln, die zu
           diesem System gehoeren.
*****************************************************************************/
class PartikelSystem 
{
public:
	PartikelSystem();
	virtual ~PartikelSystem();

   int  m_zone;
   std::vector<Partikel*> m_partikelList;

private:
   int  m_typ;
   bool m_respawn;
   int  m_maxPartikel; 
   unsigned long m_lifeTime;
   Vec m_startPosOrg;
   Vec m_startPos;

   float m_nearDist;
   float m_farDist;
 
   int m_spriteCount;
   int m_spriteID[50];

   void  clear(void);
   float getRandom(int max);

   void init_0(void);
   void init_1(void);
   void init_2(void);
   void init_3(void);
   void init_4(void);
   void init_5(void);
   void init_6(void);
   void init_7(void);

public:
   void animate(void);
   void transform(Matrix& matTranslate, Matrix& matRotate);
   void project (float nearDist, float farDist);
 
   void load(DataInputStream& dataIn);
   void init(std::vector<Sprite*>& spriteList);
   void save(DataOutputStream& dataOut);
};
#endif // !defined(PARTIKELSYSTEM_H)
