#include "stdafx.h"

#include "math.h"
#include "DataOutputStream.h"
#include "DataInputStream.h"
#include "Sprite.h"

// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/******************************************************************************/
/** \brief Konstruktor
*******************************************************************************/
Sprite::Sprite() 
{
m_delta = 0;
m_indexSize  = 0;
}

/******************************************************************************/
/** \brief Destruktor
*******************************************************************************/
Sprite::~Sprite() 
{
}

/******************************************************************************/
/** \brief Setter (Quasi ein Deepcopy) 
    \param sprite Pointer auf das Quellsprite
    \param delta  Ne' Art von Scaling 
*******************************************************************************/
void Sprite::set(Sprite* sprite, float delta) 
{
float x=0,y=0;
int index=0, i=0, n=0, w=0, h=0;
int xx=0, yy=0;

float w_ = ((float)sprite->m_width  / delta) + 1;
float h_ = ((float)sprite->m_height / delta) + 1;
int size = (int)(w_ * h_ * 4);

if (m_indexSize < size)
   {
   m_height = sprite->m_height;
   m_width  = sprite->m_width;
   delete (m_indexArray);
   m_indexArray  = new BYTE[size]; // width * height * ARGB
   m_indexSize = size;
   }

//TRACE ("Sprite::set delta=%f  h=%d w=%d h=%d w=%d\n", delta, m_height, m_width, sprite->m_height, sprite->m_width);

for (y=0, h=0; y < sprite->m_height; y+=delta, h++)
   {
   yy = sprite->m_width * 4 * (int)(y/*+0.5*/);
   for (x=0, w=0; x < sprite->m_width; x+=delta, w++)
      {
      xx = (int)(x/*+0.5*/) * 4;

      index = yy + xx + i;
      m_indexArray[n++] = sprite->m_indexArray[index];
      m_indexArray[n++] = sprite->m_indexArray[index+1];
      m_indexArray[n++] = sprite->m_indexArray[index+2];
      m_indexArray[n++] = sprite->m_indexArray[index+3];
      }
   }

m_height = h;
m_width  = w;
}

/****************************************************************************/
/** \brief Liest das Sprite-Objekt aus dem Inputstream
*   \param dataIn DataInputStream
*******************************************************************************/
void Sprite::load(DataInputStream& dataIn) //throws IOException
{
   try
      {
      int width  = dataIn.readInt();
      int height = dataIn.readInt(); 
      
      m_indexSize  = width*height*4;  // width * height * ARGB
      this->setImage(Image::RGBA256, width, height);
      
      dataIn.read(m_indexArray, 0, m_indexSize);
      }
   catch (std::exception eof)
      {
      printf( "EOF" ); //TODO: Ins Log schreiben, oder sonstwas sinnvolleres anstellen
      }
}

/******************************************************************************/
/** \brief Serialisiert das Sprite-Objekt in den Outputstream
    \param dataOut DataOutputStream
    \throws IOException 
*******************************************************************************/
void Sprite::save(DataOutputStream& dataOut) //throws IOException
{
dataOut.writeInt(m_width);
dataOut.writeInt(m_height);
dataOut.write(m_indexArray, 0, m_width*m_height*4);
}

