#if !defined(SPRITE_H)
#define SPRITE_H

#include "Image.h"
#include "DataOutputStream.h"
#include "DataInputStream.h"

/****************************************************************************/
/** \class Sprite
    \brief Sprites werden fuer Partikel verwendet. Eine Sprite ist wie eine 
           Texture, nur einfacher gestrickt. Ausserdem sind die Pixel einer 
           Sprite semitransparent.
*****************************************************************************/
class Sprite  : public Image
{
private:
   int m_indexSize;
   float m_delta;

public:
	Sprite();

   void set(Sprite* sprite, float factor);

   void load(DataInputStream& dataIn);  // throws IOException;
   void save(DataOutputStream& dataOut); //throws IOException;

   virtual ~Sprite();
};
#endif // !defined(SPRITE_H)
