#if !defined(RENDERER_H)
#define RENDERER_H

#include <vector>

#include "Frustum.h"
#include "TextureMapper.h"
#include "SpriteMapper.h"
#include "TextMapper.h"

/****************************************************************************/
/** \class Renderer
    \brief Die Hauptklasse der Renderer 3D Engine
           Dieser Klasse beinhaltet ALLE Methoden, die fuer die Nutzung
           der Engine benoetigt werden.
*****************************************************************************/
class Renderer  
{
public:
   static Renderer* getInstance();

protected:
	Renderer();

private:
 static Renderer* _instance;

public:
	virtual ~Renderer();

private:
   bool m_drawInfo;
  
   Frustum*         m_frustum;
   TextureMapper*   m_textureMapper;  

   TextMapper*      m_textMapper;
   SurfaceCache*    m_surfaceCache;
   SpriteMapper*    m_spriteMapper;

   int    m_height;
   int    m_width;
   BYTE*  m_PlanePixels;
   float* m_ZBuffer;

   bool m_isRendererInitialized;

public:

   void initRenderer(int width, int height, BYTE* data);
   void renderFrame();
   void clearZBuffer(void);

   void renderTiles(std::vector<Tile*> & tileList);     
   void renderParticles(std::vector<Partikel*> & partikelList); 
   void renderText(std::vector<Text*> & textList);     
   
private:
   void clearPlane(void);
};
#endif // !defined(RENDERER_H)
