#if !defined(SPRITEMAPPER_H)
#define SPRITEMAPPER_H

#include "PartikelManager.h"

/****************************************************************************/
/** \class SpriteMapper
    \brief Rendert die Sprites (2D-Objekte) auf die Canvas unter 
           Beruecksichtigung der Smitransparenz
*****************************************************************************/
class SpriteMapper  
{
private:
   BYTE* m_planePixels; 
   float* m_ZBuffer;

public:
   static SpriteMapper* getInstance();

private:
   static SpriteMapper* _instance;

protected:
	SpriteMapper();

public:
	virtual ~SpriteMapper();
   void render(Partikel* partikel, BYTE* pane, float* ZBuffer, int width, int height);
   void renderNeu(Partikel* partikel, BYTE* pane, float* ZBuffer, int width, int height);
};
#endif // !defined(SPRITEMAPPER_H)
