#include "stdafx.h"

#include "TextMapper.h"

// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

TextMapper* TextMapper::_instance = 0;

/****************************************************************************/
/** \brief Liefert die Singleton-Instanz
    \return Pointer auf die Instanz
*****************************************************************************/
TextMapper* TextMapper::getInstance()
{
 if (_instance == 0) 
   _instance = new TextMapper();
 return _instance;
}

/****************************************************************************/
/** \brief Konstruktor
*****************************************************************************/
TextMapper::TextMapper()
{
m_charWidth   =  9;
m_charHeight  = 13;

m_linespace   =  4;
m_charAscent  = 10;
m_charDescent =  3;
}

/****************************************************************************/
/** \brief Destruktor
*****************************************************************************/
TextMapper::~TextMapper()
{
_instance = 0; // Singleton !!!
}

/****************************************************************************/
/** \brief Zeichnet einen Text auf die Canvas
    \param pane Pointer auf die Canvas
    \param text Referenz auf ein Textobjekt
*****************************************************************************/
void TextMapper::drawText(BYTE* pane, Text& text)
   {
   if (text.m_text != 0)
      drawText(pane, text.m_text, text.m_startX, text.m_startY);
   }

/****************************************************************************/
/** \brief Zeichnet einen Text auf die Canvas
    \param pane Pointer auf die Canvas
    \param text Der zu zeichnende Text
    \param startX X-Koordinate an die der Text gezeichnet werden soll
    \param startY Y-Koordinate an die der Text gezeichnet werden soll
*****************************************************************************/
void TextMapper::drawText(BYTE* pane, char* text, int startX, int startY)
   {
   int x=startX;
   int y=startY;
   int alpha = m_texture.getAlpha();
   int xx, yy;
   
   char* btext = text;
   for (int i=0; i < (int)strlen(text); i++)
      {
      int index = 127;
      char c = btext[i];
      
      if      (c == -60) index = 128; // ƒ
      else if (c == -42) index = 129; // ÷
      else if (c == -36) index = 130; // ‹
      else if (c == -28) index = 131; // ‰
      else if (c == -10) index = 132; // ˆ
      else if (c ==  -4) index = 133; // ¸
      else if (c == -33) index = 134; // ﬂ
      else if (c < 32)   index = 127;
      else               index = c;
      
      index -=32;
      
      int tx = index % 16;
      tx = tx * m_charWidth;
      int ty = index / 16;
      ty = (ty * 17) + 7;

      for (yy=ty, y=startY; yy < (ty+m_charHeight); yy++, y++)
         {
         for (xx=tx, x= startX; xx < (tx+m_charWidth); xx++, x++)
            {
            int ix = yy * m_texture.getWidth() + xx;
            int pixIndex = m_texture.m_indexArray[ix] & 0xff;
            if (pixIndex != alpha)
               {
               int k = ((y * 640) + x) * 3; // TODO: Screenaufloesung herausziehen

               unsigned int lutIndex = (pixIndex << 1) + pixIndex;

               pane[k]   = m_texture.m_rgbLUT[lutIndex+2]; 
               pane[k+1] = m_texture.m_rgbLUT[lutIndex+1];
               pane[k+2] = m_texture.m_rgbLUT[lutIndex];
               }
            }
         }
      startX +=9;
      }
   }

/****************************************************************************/
/** \brief Liest das Charset-Objekt aus dem Inputstream
*   \param dataIn DataInputStream
*******************************************************************************/
void TextMapper::load(DataInputStream& dataIn) 
{
m_texture.load(dataIn);
}

/******************************************************************************/
/** \brief Serialisert das Charset-Objekt in den Outputstream
    \param dataOut DataOutputStream
    \throws IOException 
*******************************************************************************/
void TextMapper::save(DataOutputStream& dataOut) 
{
m_texture.save(dataOut);
}
