#if !defined(TEXTMAPPER_H)
#define TEXTMAPPER_H

#include "Texture.h"
#include "Text.h"

/****************************************************************************/
/** \class TextMapper
    \brief TextMapper Klasse
*****************************************************************************/
class TextMapper  
{
public:
   static TextMapper* getInstance();

protected:
	TextMapper();

private:
   static TextMapper* _instance;

public:
	virtual ~TextMapper();

void drawText(BYTE* pane, Text& text);
void drawText(BYTE* pane, char* text, int startX, int startY);
void load(DataInputStream& dataIn);
void save(DataOutputStream& dataOut);

private:
   Texture m_texture;

   int m_charWidth;
   int m_charHeight;

   int m_linespace;
   int m_charAscent;
   int m_charDescent;
};

#endif // !defined(TEXTMAPPER_H)
