// Animation.cpp: Implementierung der Klasse Animation.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include <math.h>
#include <vector>

#include "TArc.h"
#include "Plane.h"

#include "Vec.h"
#include "Tile.h"

#include "Animation.h"

// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/*******************************************************************************
* Destruktor
*******************************************************************************/
Animation::~Animation() 
{

}

/*******************************************************************************
* Konstruktor
*******************************************************************************/
Animation::Animation() 
{
m_aID  = -1;
m_aID2 = -1;
reset();
}

/*******************************************************************************
* Konstruktor
*******************************************************************************/
Animation::Animation(int aID) 
{
m_aID = aID;
reset();
}

/*******************************************************************************
*
*******************************************************************************/
void Animation::reset() 
{
m_dirVec.set(0,0,0);
m_stepVec.set(0,2,0);
m_len = 128;

m_waitMax   = 0;
m_waitCount = 0;

m_dir    = 0; // FORWARD
m_mode   = ANIM_FORWARD;
m_status = ANIM_STOP;
}

/*******************************************************************************
*
*******************************************************************************/
void Animation::doStep() 
{
if (m_status == ANIM_STOP)
   return;

if (m_waitCount != 0)
   {
   m_waitCount--;
   return;
   }

switch (m_dir)
   {
   case 0: // FORWARD
   m_dirVec.add(m_stepVec);
   if (m_dirVec.length() > m_len)
      {
      if (m_mode == ANIM_ROTATE)
         {
         m_dirVec.set(0,0,0);
         }
      else if (m_mode == ANIM_FWD_BACK)
         {
         m_dir = 1; // BACKWARD
         }
      else if (m_mode == ANIM_FWD_WAIT_BACK_STOP)
         {
         m_dir = 1; // BACKWARD
         m_waitCount=90;
         }
      else
         {
         m_status = ANIM_STOP;         
         }
      }
   break;

   case 1: // BACKWARD
   m_dirVec.sub(m_stepVec);
   if (m_dirVec.length() < 0.1)
// if ((m_dirVec.m_x < 0) || (m_dirVec.m_y < 0) || (m_dirVec.m_z < 0))
      {
      m_dirVec.set(0,0,0);
      m_dir = 0; //FORWARD;
      if (m_mode == ANIM_FWD_BACK)
         {
         m_dir = 0; //FORWARD;
         }
      else
         {
         m_status = ANIM_STOP;         
         }
      }
   break;
   }
}

/*******************************************************************************
*
*******************************************************************************/
void Animation::runForward() 
{
m_mode   = ANIM_FORWARD;
m_status = ANIM_RUN;
}

/*******************************************************************************
*
*******************************************************************************/
void Animation::runForwardBackward() 
{
m_mode   = ANIM_FWD_BACK;
m_status = ANIM_RUN;
}


/*******************************************************************************
*
*******************************************************************************/
void Animation::runForwardWaitBackwardStop() 
{
m_mode   = ANIM_FWD_WAIT_BACK_STOP;
m_status = ANIM_RUN;
}


/*******************************************************************************
*
*******************************************************************************/
void Animation::stop() 
{
m_status = ANIM_STOP;
}

/*******************************************************************************
*
*******************************************************************************/
int Animation::getID() 
{
return (m_aID);
}

/*******************************************************************************
*
*******************************************************************************/
int Animation::getID2() 
{
return (m_aID2);
}

/****************************************************************************/
/** \brief Liest das Animations-Objekt aus dem Inputstream
*   \param dataIn DataInputStream
*******************************************************************************/
void Animation::load(DataInputStream& dataIn) //throws IOException
{
   int x, y, z; 
   try
      {
      m_aID  = dataIn.readInt();
      m_aID2 = dataIn.readInt();
      x = dataIn.readInt();
      y = dataIn.readInt();
      z = dataIn.readInt();
      m_stepVec.set((float)x,(float)y,(float)z);
      m_len    = dataIn.readInt();
      m_mode   = dataIn.readInt();
      m_status = dataIn.readInt();
      }
   catch (std::exception eof)
      {
      printf( "EOF" );  // TODO: Vernuenftige Fehlermeldung...
      }
}

/******************************************************************************/
/** \brief Serialisiert das Animations-Objekt in den Outputstream
    \param dataOut DataOutputStream
    \throws IOException 
*******************************************************************************/
void Animation::save(DataOutputStream& dataOut) //throws IOException
{
   dataOut.writeInt(m_aID);
   dataOut.writeInt(m_aID2);
   dataOut.writeInt((int)m_stepVec.m_x);
   dataOut.writeInt((int)m_stepVec.m_y);
   dataOut.writeInt((int)m_stepVec.m_z);
   dataOut.writeInt(m_len);
   dataOut.writeInt(m_mode);
   dataOut.writeInt(m_status);
}

