#if !defined(ANIMATION_H)
#define ANIMATION_H

/****************************************************************************/
/** \class Animation
    \brief Zustandklasse fuer eine Animation
*****************************************************************************/
class Animation  
{
private:

   enum {ANIM_STOP=0,      // Animation ist gestoppt
         ANIM_RUN=1,       // Animation wird fortgefuehrt
         ANIM_FORWARD=2,   // Animation vorwaerts, dann STOP
         ANIM_BACKWARD=3,  // Animation rueckwaerts, dann STOP
         ANIM_ROTATE=4,    // Animation vorwaerts rotierend
         ANIM_FWD_BACK=5,  // Animation vorwaerts, dann Rueckwaerts
         ANIM_WAIT=6,
         ANIM_FWD_WAIT_BACK_STOP=7}; // Animation vorwaerts, warten , Rueckwaerts, dann STOP
   
   Vec m_stepVec;

   int m_aID;
   int m_aID2;

   int m_dir;

   int m_len;

   int m_status;
   int m_mode;

   int m_waitMax;
   int m_waitCount;

   void reset(void);

public:
   Vec m_dirVec;

   Animation();
	Animation(int aID);
   
   void runForward(void);    
   void runForwardBackward();
   void runForwardWaitBackwardStop();
   void stop();    

   void doStep();
   
   void translate(Tile& tile);
   int getID(void);
   int getID2(void);

   void load(DataInputStream& dataIn);  // throws IOException;
   void save(DataOutputStream& dataOut); //throws IOException;

   virtual ~Animation();
};
#endif // !defined(ANIMATION_H)
