// AnimationPool.cpp: Implementierung der Klasse AnimationPool.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include <vector>

#include <math.h>
#include <vector>

#include "TArc.h"
#include "Matrix.h"
#include "Plane.h"

#include "Vec.h"
#include "Tile.h"

#include "Animation.h"

#include "AnimationManager.h"

// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

AnimationManager* AnimationManager::_instance = 0;

/****************************************************************************/
/** \brief Liefert die Singleton-Instanz
    \return Pointer auf die Instanz
*****************************************************************************/
AnimationManager* AnimationManager::getInstance()
{
 if (_instance == 0) 
   _instance = new AnimationManager();
 return _instance;
}


/****************************************************************************/
/** \brief Konstruktor
*****************************************************************************/
AnimationManager::AnimationManager()
{
}

/****************************************************************************/
/** \brief Destruktor
*****************************************************************************/
AnimationManager::~AnimationManager()
{
clear();
_instance = 0; // Singleton !!!
}

/*******************************************************************************
* Voodoo !
*******************************************************************************/
void AnimationManager::clear(void)
{
for (unsigned int i=0; i < m_animList.size(); i++)
   {
   Animation* t = (Animation*)m_animList[i];
   delete (t);
   }
}

/*******************************************************************************
* Voodoo !
*******************************************************************************/
int AnimationManager::add(int aID)
{
unsigned int i;
Animation* anim;
for ( i=0; i < m_animList.size(); i++)
   {
   anim = (Animation*)m_animList[i];
   if (aID == anim->getID())
      return (i);
   }

anim = new Animation(aID);
m_animList.push_back(anim);
return (i);
}

/*******************************************************************************
*
*******************************************************************************/
Animation* AnimationManager::get(int aID)
{
  if ((aID >= 0) && (aID < (int)m_animList.size()))
     {
     return ((Animation*)m_animList[aID]);
     }

  return (&m_animDummy);
}

/*******************************************************************************
*
*******************************************************************************/
void AnimationManager::animate(void)
{
for (unsigned int i=0; i < m_animList.size(); i++)
   {
   Animation* anim = (Animation*)m_animList[i];
   anim->doStep();
   }
}

/****************************************************************************/
/** \brief Liest den AnimationPool aus dem Inputstream
*   \param dataIn DataInputStream
*   \throws IOException 
*******************************************************************************/
void AnimationManager::load(DataInputStream& dataIn) //throws IOException
{
int i=0, size=0;
m_animList.clear();
try
   {
   size = dataIn.readInt();
   for (i=0; i < size; i++)
      {
      Animation* anim = new  Animation();
      anim->load(dataIn);
      m_animList.push_back(anim);
      }
   }
catch (std::exception eof)
   {
   printf( "EOF" ); // TODO: Vernuenftige Fehlermeldung...
   }
}

/******************************************************************************/
/** \brief Serialisiert das AnimationManager-Objekt in den Outputstream
    \param dataOut DataOutputStream
    \throws IOException 
*******************************************************************************/
void AnimationManager::save(DataOutputStream& dataOut) //throws IOException
{
int i, size;

size = m_animList.size();

dataOut.writeInt(size);
for (i=0; i < size; i++)
  {
  Animation* anim  = (Animation*)m_animList[i];
  anim->save(dataOut);
  }
}
