#if !defined(ANIMATIONMANAGER_H)
#define ANIMATIONMANAGER_H

#include "Animation.h"

/****************************************************************************/
/** \class AnimationManager
    \brief Container fuer alle Animationen
*****************************************************************************/
class AnimationManager  
{
public:
   static AnimationManager* getInstance();

private:
  static AnimationManager* _instance;

protected:
	AnimationManager();

public:
	virtual ~AnimationManager();

private:
  Animation m_animDummy;

  std::vector<Animation*> m_animList;

public:
 void clear(void);

 int add(int aID);
 Animation* get(int aID);
 void animate(void);

 void load(DataInputStream& dataIn);  // throws IOException;
 void save(DataOutputStream& dataOut); //throws IOException;

};

#endif // !defined(ANIMATIONMANAGER_H)
