#include "StdAfx.h"
#include "Image.h"

/****************************************************************************/
/** \brief Konstruktor
*****************************************************************************/
Image::Image()
{
 m_typ = UNKNOWN;   
 m_height =  0;
 m_width  =  0;
 m_shift  =  0;
 m_alpha  = -1;
 
 m_rgbLUT =  0;
 m_indexArray  = 0;
}

/****************************************************************************/
/** \brief Destruktor
*****************************************************************************/
Image::~Image(void)
{
if (m_rgbLUT != 0)
   delete (m_rgbLUT);
   
if (m_indexArray != 0)
   delete (m_indexArray);
}

/****************************************************************************/
/** \brief setImage
    \param typ Imagetyp (PALETTE, RGB, RGBA01, RGBA256)
    \param width Imagebreite (in Pixel)
    \param height Imagehoehe (in Pixel)
*****************************************************************************/
void Image::setImage(IMAGE_TYP typ, int width, int height)
{
m_typ    = typ;
m_width  = width;
m_height = height;

setShift();

switch (typ)
   {
   case PALETTE:
   m_rgbLUT = new BYTE[256*3];
   m_indexArray  = new BYTE[m_width*m_height];  
   break;
   
   case RGB:
   m_indexArray  = new BYTE[m_width*m_height*3];  
   break;
   
   case RGBA01:
   m_indexArray  = new BYTE[m_width*m_height*4];  
   break;

   case RGBA256:
   m_indexArray  = new BYTE[m_width*m_height*4];  
   break;
   
   default:
   break;
   }   
}

/****************************************************************************/
/** \brief Setzt den Shiftwert (fuer schnelle Multiplikation ^2) 
*****************************************************************************/
void Image::setShift(void)
{
  switch (m_width)
     {
     case 32:  m_shift = 5; break;
     case 64:  m_shift = 6; break;
     case 128: m_shift = 7; break;
     case 256: m_shift = 8; break;
     case 512: m_shift = 9; break;
     default:  m_shift = 0; break;
     }
}

/****************************************************************************/
/** \brief Getter fuer die Imagehoehe (in Pixel)
    \return Hoehe
*****************************************************************************/
int Image::getHeight(void)
{
return (m_height);
}

/****************************************************************************/
/** \brief Getter fuer die Imagebreite (in Pixel)
    \return Breite
*****************************************************************************/
int Image::getWidth(void)
{
return (m_width);
}

/****************************************************************************/
/** \brief Getter fuer den Paletten-Index fuer die Transparenz 
           (nur bei RGBA01)
    \return Alphaindex
*****************************************************************************/
int Image::getAlpha(void) 
{
return (m_alpha);
}

/****************************************************************************/
/** \brief Setter fuer den Paletten-Index fuer die Transparenz 
           (nur bei RGBA01)
    \param alpha
*****************************************************************************/
void Image::setAlpha(int alpha)
{
m_alpha = alpha;
}


