#if !defined(IMAGE_H)
#define IMAGE_H

/****************************************************************************/
/** \class Image
    \brief Generische Klasse fuer Images, Bitmaps
 ****************************************************************************/
class Image
{
public:
 enum IMAGE_TYP {UNKNOWN = 0,
                 PALETTE = 1, // Palettenimage
                 RGB     = 2, // RGB-Image
                 RGBA01  = 3, // RGBA mit A:0->Transparent, A:1->Sichtbar
                 RGBA256 = 4  // RGBA mit A:0..256 (Semitransparenz) 
                 }; 
 int m_typ;   
 int m_height;
 int m_width;
 int m_shift;
 int m_alpha;
 
 BYTE* m_rgbLUT;
 BYTE* m_indexArray;

public:
   Image();
   ~Image(void);
   
   void setImage(IMAGE_TYP, int width, int height);
   int  getHeight(void);
   int  getWidth(void);
   int  getAlpha(void);
   void setAlpha(int alpha);
      
private:
   void setShift(void);
};
#endif // !defined(IMAGE_H)
