#include "stdafx.h"

#include <math.h>
#include <vector>

#include "DataInputStream.h"
#include "DataOutputStream.h"
#include "Timer.h"

#include "Material.h"

// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/*******************************************************************************
* Destruktor
*******************************************************************************/
Material::~Material() 
{
m_textureList.clear();
}

/*******************************************************************************
* Konstruktor
*******************************************************************************/
Material::Material() 
{
m_time  = 0;
m_index = 0;
}

/****************************************************************************/
/** \brief Getter fuer die Material-ID
*   \return Material-ID
*******************************************************************************/
int Material::getID(void)
{
return (m_mid);
}

/****************************************************************************/
/** \brief Getter fuer die Texture-ID
*   \return Texture-ID
*******************************************************************************/
int Material::getTID(void)
{
bool anim = false;
unsigned long t1 = getMSTimer();
unsigned long delta = t1 - m_time;
if (delta > 100)
   {
   m_time = t1;
   anim=true;
   } 

if (anim == true)
   {
   m_index++;
   }

int size = m_textureList.size();
if (m_index >= size)
   m_index = 0;
   

int tid = m_textureList[m_index];
return (tid);
}


/****************************************************************************/
/** \brief Liest das Material-Objekt aus dem Inputstream
*   \param dataIn DataInputStream
*   \throws IOException 
*******************************************************************************/
void Material::load(DataInputStream& dataIn) //throws IOException
{
   int i=0, size=0, tid=-1;
   try
      {
      m_mid = dataIn.readInt();
      size = dataIn.readInt();
      for (i=0; i < size; i++)
         {
         tid = dataIn.readInt();
         m_textureList.push_back(tid);
         }
      }
   catch (std::exception eof)
      {
      printf( "EOF" ); // TODO: Logfile schreiben
      }
}

/******************************************************************************/
/** \brief Serialisiert das Material-Objekt in den Outputstream
    \param dataOut DataOutputStream
    \throws IOException 
*******************************************************************************/
void Material::save(DataOutputStream& dataOut) //throws IOException
{
   int i=0, size=0, tid=0;

   dataOut.writeInt(m_mid);
   size = m_textureList.size();
   dataOut.writeInt(size);
   for (i=0; i<size; i++)
      {
      tid = m_textureList[i];
      dataOut.writeInt(tid);    
      }
}

