// MaterialManager.cpp: Implementierung der Klasse MaterialManager.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include <vector>

#include "DataOutputStream.h"
#include "DataInputStream.h"

#include "MaterialManager.h"

// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

MaterialManager* MaterialManager::_instance = 0;

/****************************************************************************/
/** \brief Liefert die Singleton-Instanz
    \return Pointer auf die Instanz
*****************************************************************************/
MaterialManager* MaterialManager::getInstance()
{
 if (_instance == 0) 
   _instance = new MaterialManager();
 return _instance;
}

/****************************************************************************/
/** \brief Konstruktor
*****************************************************************************/
MaterialManager::MaterialManager() {}

/****************************************************************************/
/** \brief Destruktor
*****************************************************************************/
MaterialManager::~MaterialManager()
{
clear();
_instance = 0; // Singleton !!!
}

/*******************************************************************************
* 
*******************************************************************************/
void MaterialManager::clear(void)
{
for (unsigned int i=0; i < texList.size(); i++)
   {
   Texture* t = (Texture*)texList[i];
   delete (t);
   }

texList.clear();
}

/*******************************************************************************
* 
*******************************************************************************/
void MaterialManager::add(Texture* t)
{
texList.push_back(t);
}

/*******************************************************************************
*
*******************************************************************************/
int MaterialManager::countTextures(void)
{
  return(texList.size());
}

/*******************************************************************************
*
*******************************************************************************/
/*
Texture* MaterialManager::get(int index)
{
  if ((index >= 0) && (index < (int)texList.size()))
     {
     return ((Texture*)texList[index]);
     }
  else
     {
     return (&texDummy);
     }
}
*/
/*******************************************************************************
*
*******************************************************************************/
Texture* MaterialManager::get(int index)
{
  Material* mat = matList[index];
  int tid = mat->getTID();
  Texture* tex = texList[tid];
  return (tex);
}

/****************************************************************************/
/** \brief Liest den MaterialManager aus dem Inputstream
*   \param dataIn DataInputStream
*******************************************************************************/
void MaterialManager::load(DataInputStream& dataIn) 
{
   int i=0, size=0;
   try
      {
      // Texturen laden:
      size = dataIn.readInt();
      for (i=0; i < size; i++)
         {
         Texture* t = new Texture();
         t->load(dataIn);
         texList.push_back(t);
         }

      // Materialien laden:
      size = dataIn.readInt();
      for (i=0; i < size; i++)
         {
         Material* mat = new Material();
         mat->load(dataIn);
         matList.push_back(mat);
         }
      }
   catch (std::exception eof)
      {
      printf("EOF"); // TODO: Logfile schreiben
      }
}

/******************************************************************************/
/** \brief Serialisiert den MaterialManager in den Outputstream
    \param dataOut DataOutputStream
    \throws IOException 
*******************************************************************************/
void MaterialManager::save(DataOutputStream& dataOut) 
{
    int size = this->countTextures();
    dataOut.writeInt(size);    // Anzahl Texturen schreiben
    for (int i=0; i < size; i++)
       {
       Texture* tex = this->get(i);
       tex->save(dataOut);
       }
}



