#if !defined(MATERIALMANAGER_H)
#define MATERIALMANAGER_H

#include "Texture.h"
#include "Material.h"

/****************************************************************************/
/** \class MaterialManager
    \brief Container fuer alle Materialien
*****************************************************************************/
class MaterialManager  
{
public:
   static MaterialManager* getInstance();

private:
  static MaterialManager* _instance;

protected:
	MaterialManager();


public:
	virtual ~MaterialManager();

private:
  std::vector<Texture*> texList;
  std::vector<Material*> matList;
 
 Texture texDummy;

public:
 void clear(void);
 void add(Texture* t);
 bool add(int mid, int tid);

 int countTextures(void);
 Texture* get(int index);

 void load(DataInputStream& dataIn);
 void save(DataOutputStream& dataOut);
};

#endif // !defined(MATERIALMANAGER_H)
