#include "stdafx.h"

#include "Vec.h"
#include "Tile.h"
#include "SkyBox.h"

// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

SkyBox* SkyBox::_instance = 0;

int const SkyBox::TILE_COUNT(6);

/****************************************************************************/
/** \brief Liefert die Singleton-Instanz
    \return Pointer auf die Instanz
*****************************************************************************/
SkyBox* SkyBox::getInstance()
{
 if (_instance == 0) 
   _instance = new SkyBox();
 return _instance;
}

/****************************************************************************/
/** \brief Konstruktor
*****************************************************************************/
SkyBox::SkyBox()
{
// TODO: Fehler wenn 2d != Texturewidth: Warum!!! Keine Ahnung
float d = 256;  // Distanz der Tiles vom Ursprung (0,0,0)
                // Die Seitenlaenge einer Tile ist demnach 2d
m_use  = false;
m_zone = 0;

Vec v0(-d, d, d);
Vec v1( d, d, d);
Vec v2( d,-d, d);
Vec v3(-d,-d, d);

Vec v4(-d, d,-d);
Vec v5( d, d,-d);
Vec v6( d,-d,-d);
Vec v7(-d,-d,-d);

m_tiles[TILE_LEFT] = new Tile(v4, v0, v3, v7, Tile::WALL,  0, 0, "SkyBox_Left");  // negative x
m_tiles[TILE_FRONT]= new Tile(v0, v1, v2, v3, Tile::WALL,  0, 0, "SkyBox_Front"); // positive z
m_tiles[TILE_DOWN] = new Tile(v3, v2, v6, v7, Tile::FLOOR, 0, 0, "SkyBox_Down");  // negative y
m_tiles[TILE_TOP]  = new Tile(v4, v5, v1, v0, Tile::FLOOR, 0, 0, "SkyBox_Top");   // positive y
m_tiles[TILE_RIGHT]= new Tile(v1, v5, v6, v2, Tile::WALL,  0, 0, "SkyBox_Right"); // positive x
m_tiles[TILE_BACK] = new Tile(v5, v4, v7, v6, Tile::WALL,  0, 0, "SkyBox_Back");  // negative z

for (int i = 0; i < TILE_COUNT; i++)
   m_tiles[i]->calcUV();

for (int i = 0; i < TILE_COUNT; i++)
   m_tiles[i]->reverseVertices();
   
}

/****************************************************************************/
/** \brief Destruktor
*****************************************************************************/
SkyBox::~SkyBox()
{
for (int i = 0; i < 6; i++)
   delete m_tiles[i];
_instance = 0; // Singleton !!!
}

/*******************************************************************************
* setZone
* @param zone
*******************************************************************************/
void SkyBox::setZone(int zone){m_zone = zone;}

/*******************************************************************************
* reset
*******************************************************************************/
void SkyBox::reset()
{
m_use = false;
}

/*******************************************************************************
* test
* @param zone
*******************************************************************************/
void SkyBox::test(int zone)
{
if (m_zone == zone)
   m_use = true;
}

/*******************************************************************************
* test
*******************************************************************************/
bool SkyBox::test()
{
return (m_use);
}

/*******************************************************************************
* setLeft
* @param textureID
*******************************************************************************/
void SkyBox::setLeft(int textureID){m_tiles[TILE_LEFT]->m_textureID = textureID;}

/*******************************************************************************
* setFront
* @param textureID
*******************************************************************************/
void SkyBox::setFront(int textureID){m_tiles[TILE_FRONT]->m_textureID = textureID;}

/*******************************************************************************
* setDown
* @param textureID
*******************************************************************************/
void SkyBox::setDown(int textureID){m_tiles[TILE_DOWN]->m_textureID = textureID;}

/*******************************************************************************
* setTop
* @param textureID
*******************************************************************************/
void SkyBox::setTop(int textureID){m_tiles[TILE_TOP]->m_textureID = textureID;}

/*******************************************************************************
* setRight
* @param textureID
*******************************************************************************/
void SkyBox::setRight(int textureID){m_tiles[TILE_RIGHT]->m_textureID = textureID;}

/*******************************************************************************
* setBack
* @param textureID
*******************************************************************************/
void SkyBox::setBack(int textureID){m_tiles[TILE_BACK]->m_textureID = textureID;}

/****************************************************************************/
/** \brief Liest das SkyBox-Objekt aus dem Inputstream
*   \param dataIn DataInputStream
*******************************************************************************/
void SkyBox::load(DataInputStream& dataIn) 
{
   try
      {
      m_zone = dataIn.readInt();
      for (int i=0; i < TILE_COUNT; i++)
         m_tiles[i]->m_textureID = dataIn.readInt();
      }
   catch (std::exception eof)
      {
      printf("EOF"); // TODO: Logfile schreiben
      }
}

/******************************************************************************/
/** \brief Serialisiert das SkyBox-Objekt in den Outputstream
    \param dataOut DataOutputStream
    \throws IOException 
*******************************************************************************/
void SkyBox::save(DataOutputStream& dataOut) 
{
dataOut.writeInt(m_zone);
for (int i=0; i < TILE_COUNT; i++)
   dataOut.writeInt(m_tiles[i]->m_textureID);
}
