#if !defined(SKYBOX_H)
#define SKYBOX_H

/****************************************************************************/
/** \class SkyBox
    \brief SkyBox Klasse
*****************************************************************************/
class SkyBox  
{
public:
   static SkyBox* getInstance();

protected:
	SkyBox();

private:
   static SkyBox* _instance;

public:
	virtual ~SkyBox();

static int const TILE_COUNT; // = 6

enum SKYBOX_SIDES {TILE_LEFT   = 0,  // negative x
                   TILE_FRONT  = 1,  // positive z
                   TILE_DOWN   = 2,  // negative y
                   TILE_TOP    = 3,  // positive y
                   TILE_RIGHT  = 4,  // positve  x
                   TILE_BACK   = 5}; // negative z
Tile* m_tiles[6];

void setZone(int zone);

void reset();
void test(int zone);
bool test();

void setLeft(int textureID);
void setFront(int textureID);
void setDown(int textureID);
void setTop(int textureID);
void setRight(int textureID);
void setBack(int textureID);

void load(DataInputStream& dataIn);
void save(DataOutputStream& dataOut);

private:
int  m_zone;
bool m_use;
};

#endif // !defined(SKYBOX_H)
