#include "StdAfx.h"
#include "Texture.h"
#include "LightMap.h"

#include "Surface.h"

/****************************************************************************/
/** \brief Konstruktor
    \param sid Surface-ID
    \param texture Paletten-Image mit oder ohne Transparenz
*****************************************************************************/
Surface::Surface(unsigned long sid, Texture& texture)
{
m_sid = sid;
int i,k, alpha;

alpha = texture.getAlpha();
if (alpha == -1)
   {   
   setImage(Image::RGB, texture.getWidth(), texture.getHeight());
   for (i=0, k=0; i<(m_height*m_width); i++)
      {
      int pixIndex = texture.m_indexArray[i] & 0xff;
      unsigned int lutIndex = (pixIndex << 1) + pixIndex;
 
      m_indexArray[k++] = texture.m_rgbLUT[lutIndex];
      m_indexArray[k++] = texture.m_rgbLUT[lutIndex+1];
      m_indexArray[k++] = texture.m_rgbLUT[lutIndex+2];
      }
   }
else
   {
   setImage(Image::RGBA01, texture.getWidth(), texture.getHeight());
   for (i=0, k=0; i<(m_height*m_width); i++)
      {
      int pixIndex = texture.m_indexArray[i] & 0xff;
      unsigned int lutIndex = (pixIndex << 1) + pixIndex;
 
      m_indexArray[k++] = texture.m_rgbLUT[lutIndex];
      m_indexArray[k++] = texture.m_rgbLUT[lutIndex+1];
      m_indexArray[k++] = texture.m_rgbLUT[lutIndex+2];
      if (lutIndex == alpha)
         m_indexArray[k++] = 0;
      else
         m_indexArray[k++] = 1;   
      } 
   }
}

/****************************************************************************/
/** \brief Konstruktor
    \param sid Surface-ID
    \param texture Paletten-Image mit oder ohne Transparenz
    \param lightmap LightMap
    \param rgbIntensity Mappingmatrix
    \param intensity
*****************************************************************************/
Surface::Surface(unsigned long sid, Texture& texture, LightMap* lightmap, 
                 BYTE rgbIntensity[256][256], BYTE intensity)
{
m_sid = sid;
int i,k,alpha;

alpha = texture.getAlpha();
if (alpha == -1)
   {
   setImage(Image::RGB, texture.getWidth(), texture.getHeight());
   for (i=0, k=0; i<(m_height*m_width); i++)
      {
      int pixIndex = texture.m_indexArray[i] & 0xff;
      unsigned int lutIndex = (pixIndex << 1) + pixIndex;
 
      BYTE intensity_ = intensity;
      if (lightmap != 0)
         intensity_ += lightmap->m_map[i];

      m_indexArray[k++] = rgbIntensity[texture.m_rgbLUT[lutIndex]][intensity_];
      m_indexArray[k++] = rgbIntensity[texture.m_rgbLUT[lutIndex+1]][intensity_];
      m_indexArray[k++] = rgbIntensity[texture.m_rgbLUT[lutIndex+2]][intensity_];
      }   
   }
else
   {
   setImage(Image::RGBA01, texture.getWidth(), texture.getHeight());
   for (i=0, k=0; i<(m_height*m_width); i++)
      {
      int pixIndex = texture.m_indexArray[i] & 0xff;
      unsigned int lutIndex = (pixIndex << 1) + pixIndex;
 
      BYTE intensity_ = intensity;
      if (lightmap != 0)
         intensity_ += lightmap->m_map[i];

      m_indexArray[k++] = rgbIntensity[texture.m_rgbLUT[lutIndex]][intensity_];
      m_indexArray[k++] = rgbIntensity[texture.m_rgbLUT[lutIndex+1]][intensity_];
      m_indexArray[k++] = rgbIntensity[texture.m_rgbLUT[lutIndex+2]][intensity_];
      if (lutIndex == alpha)
         m_indexArray[k++] = 0;
      else
         m_indexArray[k++] = 1;   
      }   
   }
}

/****************************************************************************/
/** \brief Destruktor
*****************************************************************************/
Surface::~Surface(void)
{
}
