#if !defined(SURFACE_H)
#define SURFACE_H

#include "Image.h"
/****************************************************************************/
/** \class Surface
    \brief Eine Surface (Oberflaeche) besteht aus Textur + Lightmap
           Die Datenablage erfolgt maximal performant fuer den TexturMapper
           --> RGB pro Pixel
           
           Bytes/Pixel:   1     3     4    !     1000
           --------------------------------!----------
            64*64      =  4K   12K   16K   !      16M
           128*128     = 16K   48K   64K   !      64M
           256*256     = 64K  192K  256K   !     256M
           
 ****************************************************************************/
class Surface : public Image
{
public:
 unsigned long m_sid;

public:
   int m_counter;
   Surface(unsigned long sid, Texture& texture);
   Surface(unsigned long sid, Texture& texture, LightMap* lightMap, BYTE rgbIntensity[256][256], BYTE intensity);
  ~Surface(void);
   
private:
   void init(unsigned long sid, Texture& texture);   
};
#endif // !defined(SURFACE_H)
