#include "StdAfx.h"
#include "SurfaceCache.h"

SurfaceCache* SurfaceCache::_instance = 0;

/****************************************************************************/
/** \brief Liefert die Singleton-Instanz
    \return Pointer auf die Instanz
*****************************************************************************/
SurfaceCache* SurfaceCache::getInstance()
{
 if (_instance == 0) 
   _instance = new SurfaceCache();
 return _instance;
}

/****************************************************************************/
/** \brief Konstruktor
*****************************************************************************/
SurfaceCache::SurfaceCache(void)
{  
   m_sid  = 0;
   m_usedCounter = 0;
   
   for (int i=0; i < MAX_SURFACES; i++)
      m_surfaces[i] = 0;
      
   for (int c=0; c < 256; c++)
      for (int i=0; i < 256; i++)
         m_rgbIntensity[c][i] = (BYTE)((c * i) >> 8);
}

/****************************************************************************/
/** \brief Destruktor
*****************************************************************************/
SurfaceCache::~SurfaceCache(void)
{
   for (int i=0; i < MAX_SURFACES; i++)
      if (m_surfaces[i] != 0)
         {
         delete (m_surfaces[i]);
         m_surfaces[i] = 0;
         }
_instance = 0; // Singleton !!!
}

/****************************************************************************/
/** \brief addSurface
    \param texture Textur
    \return sid, -1, -2
*****************************************************************************/
long SurfaceCache::addSurface(Texture& texture)
{
   long sid = m_sid++; // FIXME: Ueberlauf abfangen
   
   for (int i=0; i < MAX_SURFACES; i++)
      if (m_surfaces[i] == 0)
         {
         m_surfaces[i] = new Surface(sid, texture);
         if (m_surfaces[i] == 0)
            return (-2);
         return (sid); 
         }
   return (-1); // ERROR
}

/****************************************************************************/
/** \brief updateSurface
    \param sid 
    \param texture Textur
    \return sid, -1, -2
*****************************************************************************/
long SurfaceCache::updateSurface(long sid, Texture& texture)
{
   for (int i=0; i < MAX_SURFACES; i++)
      if ((m_surfaces[i] != 0) && (m_surfaces[i]->m_sid == sid))
         {
         delete (m_surfaces[i]);
         m_surfaces[i] = new Surface(sid, texture);
         
         if (m_surfaces[i] == 0)
            return (-2);
         return (sid); 
         }
   return (-1); // ERROR
}

/****************************************************************************/
/** \brief addSurface
    \param texture Textur
    \param lightMap
    \param intensity    
    \return sid, -1, -2
*****************************************************************************/
long SurfaceCache::addSurface(Texture& texture, LightMap* lightMap, BYTE intensity)
{
   long sid = m_sid++; // FIXME: Ueberlauf abfangen
   
   for (int i=0; i < MAX_SURFACES; i++)
      if (m_surfaces[i] == 0)
         {
         m_surfaces[i] = new Surface(sid, texture, lightMap, m_rgbIntensity, intensity);
         if (m_surfaces[i] == 0)
            return (-2);
         return (sid); 
         }
   return (-1); // ERROR
}

/****************************************************************************/
/** \brief updateSurface
    \param sid 
    \param texture Textur
    \param lightMap
    \param intensity    
    \return sid, -1, -2
*****************************************************************************/
long SurfaceCache::updateSurface(long sid, Texture& texture, LightMap* lightMap, BYTE intensity)
{
   for (int i=0; i < MAX_SURFACES; i++)
      if ((m_surfaces[i] != 0) && (m_surfaces[i]->m_sid == sid))
         {
         delete (m_surfaces[i]);
         m_surfaces[i] = new Surface(sid, texture, lightMap, m_rgbIntensity, intensity);
         
         if (m_surfaces[i] == 0)
            return (-2);
         return (sid); 
         }
   return (-1); // ERROR
}

/****************************************************************************/
/** \brief getSurface
    \param sid Surface ID
    \return Pointer auf Surface, oder NULL
*****************************************************************************/
Surface* SurfaceCache::getSurface(long sid)
{
   for (int i=0; i < MAX_SURFACES; i++) //TODO: sorted list
      if ((m_surfaces[i] != 0) && (m_surfaces[i]->m_sid == sid))
         {
         m_surfaces[i]->m_counter=0;
         return (m_surfaces[i]);
         }
         
   return (0);
}

/****************************************************************************/
/** \brief refresh
*****************************************************************************/
void SurfaceCache::refresh()
{
   m_usedCounter=0;
   for (int i=0; i < MAX_SURFACES; i++)
      {
      if (m_surfaces[i] != 0)
         {
         m_surfaces[i]->m_counter++;
         if (m_surfaces[i]->m_counter > MAX_DROP)
            {
            delete (m_surfaces[i]);
            m_surfaces[i] = 0;
            }
         else
            {
            m_usedCounter++;
            }   
         }
      }            
}

/****************************************************************************/
/** \brief getCount
    \return Anzahl Surfaces
*****************************************************************************/
int SurfaceCache::getCount()
{
return (m_usedCounter);
}
