#include "stdafx.h"

#include "Timer.h"
#include "Texture.h"

// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/****************************************************************************/
/** \brief Konstruktor
*****************************************************************************/
Texture::Texture() 
{
m_time  = 0; 
}

/****************************************************************************/
/** \brief Destruktor
*****************************************************************************/
Texture::~Texture() 
{
}

/****************************************************************************/
/** \brief Liest das Textur-Objekt aus dem Inputstream
*   \param dataIn DataInputStream
*******************************************************************************/
void Texture::load(DataInputStream& dataIn) 
{
   int i;

   BYTE redLUT[256];
   BYTE greenLUT[256];
   BYTE blueLUT[256];

   try
      {
      int width  = dataIn.readInt();
      int height = dataIn.readInt();
      int alpha  = dataIn.readInt();
      setImage(Image::PALETTE, width, height);
      setAlpha(alpha);

      dataIn.read(redLUT,   0, 256);
      dataIn.read(greenLUT, 0, 256);
      dataIn.read(blueLUT,  0, 256);

      for (i=0; i< 256; i++)
         {
         m_rgbLUT[i*3]   = redLUT[i];
         m_rgbLUT[i*3+1] = greenLUT[i];
         m_rgbLUT[i*3+2] = blueLUT[i];
         }

      dataIn.read(m_indexArray, 0, m_width*m_height);
      }
   catch (std::exception eof)
      {
      printf( "EOF" ); // TODO: Logfile schreiben
      }
}

/******************************************************************************/
/** \brief Serialisiert das Textur-Objekt in den Outputstream
    \param dataOut DataOutputStream
    \throws IOException 
*******************************************************************************/
void Texture::save(DataOutputStream& dataOut) //throws IOException
{
dataOut.writeInt(m_width);
dataOut.writeInt(m_height);
dataOut.writeInt(m_alpha);

dataOut.write(m_rgbLUT,     0, 256);
dataOut.write(m_rgbLUT+256, 0, 256);
dataOut.write(m_rgbLUT+512, 0, 256);

dataOut.write(m_indexArray, 0, m_width*m_height);
}

/******************************************************************************/
/** \brief Scroll die Textur um ein Pixel TODO: Nach Image auslagern
    \param dir Scrollrichtung
*******************************************************************************/
void Texture::scroll(int dir) 
{
int x, y, i, n, index;
BYTE val, row[512];

if (m_indexArray == 0)
   return;

bool anim = false;
unsigned long t1 = getMSTimer();
unsigned long delta = t1 - m_time;
if (delta > 10)
   {
   m_time = t1;
   anim=true;
   } 

if (anim == false)
   return;

//m_width  = 8;
//m_height = 8;

//int _dir = 4;
switch (dir)
   {
   case 1: // Scroll nach Links <===
   for (y=0; y < m_height; y++)
      {
      index = y * m_width; 
      val = m_indexArray[index];
   
      for (x=0; x < (m_width-1); x++)
         m_indexArray[index + x] = m_indexArray[index + x + 1];

      m_indexArray[index + x] = val;
      }
   break;

   case 2: // Scroll nach Rechts ===>
   for (y=0; y < m_height; y++)
      {
      index = y * (m_width); 
      val = m_indexArray[index+m_width-1];
   
      for (x=m_width-1; x > 0; x--)
         m_indexArray[index + x] = m_indexArray[index + x - 1];

      m_indexArray[index] = val;
      }
   break;

   case 3: // Scroll nach Oben 
   for (i=0; i < m_width; i++)
      row[i] = m_indexArray[i];

   for (i=m_width, n=0; i < (m_width * m_height); i++, n++)
      m_indexArray[n] = m_indexArray[i];

   for (i=0, n = m_width * (m_height-1); i < m_width; i++, n++)
      m_indexArray[n] = row[i];
   break;

   case 4: // Scroll nach Unten 
   memcpy(row, m_indexArray, m_width*sizeof(BYTE));
   memmove(m_indexArray, m_indexArray+m_width, m_width*m_height);
   memcpy(m_indexArray + (m_width * (m_height-1)), row, m_width*sizeof(BYTE));
   break;
   }
}
