#include "stdafx.h"
#include "DataInputStream.h"

// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#pragma warning( disable : 4996 )

/****************************************************************************/
/** \brief Konstruktor, oeffnet die Binaerdatei zum lesen
    \param fname Dateiname
    \throws std::exception falls Datei nicht geoeffnet werden konnte
*****************************************************************************/
DataInputStream::DataInputStream(char* fname)
{
p = 0;

p = fopen (fname, "rb");
if (p == 0)
  throw std::exception(); // TODO: Eingene Exception-Klasse bauen (abgeleitet 
                          //       von std::exception, aber mit what-Erweiterung)
}

/****************************************************************************/
/** \brief Destruktor, schliesst die Binaerdatei
*****************************************************************************/
DataInputStream::~DataInputStream()
{
close();
}

/****************************************************************************/
/** \brief Schliesst die Binaerdatei
*****************************************************************************/
void DataInputStream::close()
{
if (p != 0)
  fclose(p);
}

/****************************************************************************/
/** \brief Liest eine Anzahl von Bytes aus der Binaerdatei
    \param buf BYTE (bzw. unsigned char)-Datenbuffer der gefuellt wird (Speicher
               muss von der aufrufenden Funktion bereitgestellt werden)
    \param start deprecated -  wird nicht verwendet
    \param len Anzahl der zu lesenden Bytes
*****************************************************************************/
void DataInputStream::read(BYTE* buf, int start, int len)
{
/*int l =*/ fread(buf, sizeof(BYTE), len, p);
}

/****************************************************************************/
/** \brief Liest einen int-Wert aus der Binaerdatei
    \return int-Wert
*****************************************************************************/
int DataInputStream::readInt(void)
{
int len=0, val=0;

unsigned char bufSwap[2];
unsigned char buf[4];

len = fread(buf, sizeof(int), 1, p);

bufSwap[0] = buf[0];
bufSwap[1] = buf[1];

buf[0] = buf[3];
buf[1] = buf[2];
buf[2] = bufSwap[1];
buf[3] = bufSwap[0];

memcpy(&val, buf, 4);

return (val);
}

/****************************************************************************/
/** \brief Liest einen double-Wert aus der Binaerdatei
    \return int-Wert
*****************************************************************************/
double DataInputStream::readDouble(void)
{
int len=0;
double val=0;

unsigned char bufSwap[4];
unsigned char buf[8];

len = fread(buf, sizeof(double), 1, p);

bufSwap[0] = buf[0];
bufSwap[1] = buf[1];
bufSwap[2] = buf[2];
bufSwap[3] = buf[3];

buf[0] = buf[7];
buf[1] = buf[6];
buf[2] = buf[5];
buf[3] = buf[4];

buf[4] = bufSwap[3];
buf[5] = bufSwap[2];
buf[6] = bufSwap[1];
buf[7] = bufSwap[0];

memcpy(&val, buf, 8);

return (val);
}

