#if !defined(DATAINPUTSTREAM_H)
#define DATAINPUTSTREAM_H

#include <stdexcept>

/****************************************************************************/
/** \class DataInputStream
    \brief Wrapperklasse zum lesen von Daten aus einer Binaerdatei. 
     Die Binaerdatei wird aus einer Java-Applikation heraus geschrieben. Daher 
     sind einige Besonderheiten bzgl. der unterschiedlichen Ablage von Variablen 
     zu beachten (Stichwort 'Byteorder' von Integers, Floats und Doubles)
*****************************************************************************/
class DataInputStream  
{
private:
   FILE* p;

public:
	DataInputStream(char* fname);

   void read(BYTE* buf, int start, int len);
   int readInt(void);
   double readDouble(void);
   void close(void);
	virtual ~DataInputStream();

};
#endif // !defined(DATAINPUTSTREAM_H)
