#include "stdafx.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "Text.h"

// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#pragma warning( disable : 4996 )

/****************************************************************************/
/** \brief Konstruktor
*****************************************************************************/
Text::Text()
{
init();
}

/****************************************************************************/
/** \brief Konstruktor mit Texteigenschaften
    \param startX  X-Bildschirmkoordinate des ersten Zeichens (in Pixel)
    \param startY  Y-Bildschirmkoordinate des ersten Zeichens (in Pixel)
    \param text    Der Text
*****************************************************************************/
Text::Text(int startX, int startY, char* text)
{
init();
set (startX, startY, text);
}

/****************************************************************************/
/** \brief Destruktor
*****************************************************************************/
Text::~Text()
{
if (m_text != 0)
   delete[] (m_text);
}

/****************************************************************************/
/** \brief Initialisierung fuer alle Konstruktoren
*****************************************************************************/
void Text::init(void)
{
m_startX = 0;
m_startY = 0;

m_len    = 0;
m_text   = 0;
}

/****************************************************************************/
/** \brief Setter fuer die Texteigenschaften
    \param startX  X-Bildschirmkoordinate des ersten Zeichens (in Pixel)
    \param startY  Y-Bildschirmkoordinate des ersten Zeichens (in Pixel)
    \param text    Der Text
*****************************************************************************/
void Text::set (int startX, int startY, char* text)
{
if (text != 0)
   {
   int len = strlen(text);
   if (m_text == 0)
      {
      m_len = len;
      m_text = new char[len+1];
      }
   else if (m_len < len)
      {
      m_len = len;
      delete[] (m_text);
      m_text = new char[len+1];
      }
            
   strcpy (m_text, text);
   m_startX = startX;
   m_startY = startY;
   }
}

