#include "stdafx.h"

#include <stdio.h>
#include <stdlib.h>

#ifdef WIN32
#include <windows.h>
#else
#include <time.h>
#endif

#include "Timer.h"

// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/****************************************************************************/
/** \brief  Timer mit Millisecond-Aufloesung
    \return Zeit in ms.
*****************************************************************************/
unsigned long getMSTimer(void)
{
#ifdef WIN32
unsigned long t = GetTickCount();
#else
// TODO: MAC-Implementation
// Aber Achtung: 1000 ist CLOCKS_PER_SEC / x = 1000; 
unsigned long t = clock() / 1000; // Gilt fuer CLOCKS_PER_SEC=1000000
                                  // Falls CLOCKS_PER_SEC=1000 --> 1
#endif

return (t);
}

/****************************************************************************/
/** \brief Konstruktor
*****************************************************************************/
Timer::Timer()
{
}

/****************************************************************************/
/** \brief Destruktor
*****************************************************************************/
Timer::~Timer()
{
}

/****************************************************************************/
/** \brief start
*****************************************************************************/
void Timer::start(void)
{
#ifdef WIN32
QueryPerformanceCounter(&m_start) ;
#else
m_start = clock();
#endif
}

/****************************************************************************/
/** \brief end
    \return Zeitdifferenz (end - start)
*****************************************************************************/
double Timer::end(void)
{
#ifdef WIN32
QueryPerformanceFrequency(&m_freq);
QueryPerformanceCounter(&m_stop) ;

LARGE_INTEGER t;
t.QuadPart = m_stop.QuadPart - m_start.QuadPart;

double val = ((double)t.QuadPart / (double)m_freq.QuadPart) ;
#else
m_stop = clock();
double val = (double)(m_stop - m_start) / (1000.0 * 1000.0);
#endif

return (val);
}
