#include "stdafx.h"

#include <stdio.h>
#include <stdlib.h>

#include "Timer.h"

#include "Trigger.h"

// MFC - Assists in finding memory leaks:
#ifdef MFC_DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#pragma warning( disable : 4996 )

/****************************************************************************/
/** \brief Konstruktor
*****************************************************************************/
Trigger::Trigger()
{
m_triggerTime = 0;
m_startTime   = 0;
}

/****************************************************************************/
/** \brief Konstruktor
    \param t Zeitintervall fuer das Trigger-Event
*****************************************************************************/
Trigger::Trigger(int t)
{
m_triggerTime = (unsigned int)t;
}

/****************************************************************************/
/** \brief Destruktor
*****************************************************************************/
Trigger::~Trigger()
{
}

/****************************************************************************/
/** \brief Setter fuer das Zeitintervall
    \param t Zeitintervall (in ms) fuer das Trigger-Event
*****************************************************************************/
void Trigger::set (int t)
{
m_triggerTime = (unsigned long)t;
}

/****************************************************************************/
/** \brief start
    \return true-->Zeitgrenze wurde ueberschritten
            false-->Zeitgrenze wurde noch nicht ueberschritten
*****************************************************************************/
bool Trigger::isTriggered(void)
{
unsigned long tnow = getMSTimer();

if (m_startTime == 0)
   m_startTime = tnow;

if ((tnow - m_startTime) > m_triggerTime)
   {
   m_startTime = tnow;
   return (true);
   }

return (false);
}
