package raycast;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/*******************************************************************************
* <p>Title: Project Raycast</p>
*
* @author   Bernhard Schulz (www.bsyte.de)
* @version 1.0
*******************************************************************************/
public class DlgRaycast extends JDialog implements KeyListener
{
  private String texturePath = null;
  
  RaycastPanel ProjectionPlane =null;
  JPanel jPanel2 = new JPanel();
  
/*******************************************************************************
*
*******************************************************************************/
  public DlgRaycast(String tp)
    {
    if (tp == null)
	    {
    	System.out.println("Kein Pfad zu den Texturen!");
    	return;
	    } 	
	  
    texturePath = tp + System.getProperty("file.separator"); // Pfad zu den Texturen		
	
    try
      {
      jbInit();
      }
    catch(Exception e)
      {
      e.printStackTrace();
      }
  }

/*******************************************************************************
*
*******************************************************************************/
  private void jbInit() throws Exception
    {
	// Hier den Pfad auf die Texturen anpassen:

    
    this.setTitle("Raycast");
    
    int width  = 320;
    int height = 200;
    ProjectionPlane =  new RaycastPanel(texturePath);
    ProjectionPlane.setBorder(BorderFactory.createEtchedBorder());
    ProjectionPlane.setMaximumSize(new Dimension(width, height));
    ProjectionPlane.setMinimumSize(new Dimension(width, height));
    ProjectionPlane.setPreferredSize(new Dimension(width, height));

    jPanel2.setBorder(BorderFactory.createEtchedBorder());
    this.addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        this_windowClosing(e);
      }
    });
    this.getContentPane().add(ProjectionPlane, BorderLayout.NORTH);
    this.getContentPane().add(jPanel2, BorderLayout.SOUTH);
    this.addKeyListener(this);
    }

/*******************************************************************************
*
*******************************************************************************/
  public void keyReleased(KeyEvent e)
    {
	ProjectionPlane.keyInput(false, e.getKeyCode());
    }

/*******************************************************************************
*
*******************************************************************************/
 public void keyPressed(KeyEvent e)
    {
 	ProjectionPlane.keyInput(true, e.getKeyCode()); 
    }
 
/*******************************************************************************
*
*******************************************************************************/
 public void keyTyped(KeyEvent e)
    {
    }

/*******************************************************************************
*
*******************************************************************************/
  void this_windowClosing(WindowEvent e)
  {
  this.dispose();
  System.exit(0);
  }
}
